/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.LivingEntityWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntries;
import xyz.nifeather.morph.backends.server.renderer.network.registries.CustomEntry;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.PandaPropertyCollection;

public class PandaWatcher
extends LivingEntityWatcher {
    public PandaWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.PANDA);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.PANDA);
    }

    public Panda.Gene getMainGene() {
        return Arrays.stream(Panda.Gene.values()).toList().get(this.read(ValueIndex.PANDA.MAIN_GENE).byteValue());
    }

    public Panda.Gene getHiddenGene() {
        return Arrays.stream(Panda.Gene.values()).toList().get(this.read(ValueIndex.PANDA.HIDDEN_GENE).byteValue());
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        Panda.Gene val;
        PandaPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(PandaPropertyCollection.class);
        if (property.equals(properties.MAIN_GENE)) {
            val = (Panda.Gene)value;
            this.writePersistent(ValueIndex.PANDA.MAIN_GENE, (byte)val.ordinal());
        }
        if (property.equals(properties.HIDDEN_GENE)) {
            val = (Panda.Gene)value;
            this.writePersistent(ValueIndex.PANDA.HIDDEN_GENE, (byte)val.ordinal());
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    protected <X> void onEntryWrite(CustomEntry<X> entry, X oldVal, X newVal) {
        super.onEntryWrite(entry, oldVal, newVal);
        if (entry.equals(CustomEntries.ANIMATION)) {
            String animId;
            switch (animId = newVal.toString()) {
                case "eat": {
                    this.writePersistent(ValueIndex.PANDA.EAT_TIMER, 100);
                    break;
                }
                case "sit": {
                    this.writePersistent(ValueIndex.PANDA.PANDA_FLAGS, (byte)8);
                    break;
                }
                case "standup": 
                case "reset": {
                    this.writePersistent(ValueIndex.PANDA.PANDA_FLAGS, (byte)0);
                }
            }
        }
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        Panda.Gene mainGene = this.getMainGene();
        Panda.Gene hiddenGene = this.getHiddenGene();
        nbt.putString("MainGene", mainGene.toString().toLowerCase());
        nbt.putString("HiddenGene", hiddenGene.toString().toLowerCase());
    }

    private Panda.Gene getGeneFromName(String name) {
        Panda.Gene[] gene = Panda.Gene.values();
        Panda.Gene match = Arrays.stream(gene).filter(g -> g.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        if (match == null) {
            this.logger.warn("Null Gene for name " + name + "?!");
            match = Panda.Gene.NORMAL;
        }
        return match;
    }
}

