/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types;

import com.github.retrooper.packetevents.protocol.entity.villager.VillagerData;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfession;
import com.github.retrooper.packetevents.protocol.entity.villager.profession.VillagerProfessions;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerType;
import com.github.retrooper.packetevents.protocol.entity.villager.type.VillagerTypes;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.types.ZombieWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.registries.ValueIndex;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.ZombieVillagerPropertyCollection;

public class ZombieVillagerWatcher
extends ZombieWatcher {
    private VillagerProfession profession;
    private VillagerType type;
    private int lvl;

    public ZombieVillagerWatcher(Player bindingPlayer) {
        super(bindingPlayer, EntityType.ZOMBIE_VILLAGER);
    }

    @Override
    protected void initRegistry() {
        super.initRegistry();
        this.register(ValueIndex.ZOMBIE_VILLAGER);
    }

    private VillagerData computeVillagerData() {
        VillagerProfession prof = this.profession == null ? VillagerProfessions.NONE : this.profession;
        VillagerType type = this.type == null ? VillagerTypes.PLAINS : this.type;
        return new VillagerData(type, prof, this.lvl);
    }

    @Override
    protected <X> void onPropertyWrite(SingleProperty<X> property, X value) {
        Villager.Type bukkitValue;
        ZombieVillagerPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(ZombieVillagerPropertyCollection.class);
        if (property.equals(properties.LEVEL)) {
            this.lvl = (Integer)value;
            this.writePersistent(ValueIndex.ZOMBIE_VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        if (property.equals(properties.TYPE)) {
            bukkitValue = (Villager.Type)value;
            this.type = Objects.requireNonNull(VillagerTypes.getByName((String)bukkitValue.key().asString()));
            this.writePersistent(ValueIndex.ZOMBIE_VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        if (property.equals(properties.PROFESSION)) {
            bukkitValue = (Villager.Profession)value;
            this.profession = Objects.requireNonNull(VillagerProfessions.getByName((String)bukkitValue.key().asString()));
            this.writePersistent(ValueIndex.ZOMBIE_VILLAGER.VILLAGER_DATA, this.computeVillagerData());
        }
        super.onPropertyWrite(property, value);
    }

    @Override
    public void writeToCompound(CompoundTag nbt) {
        super.writeToCompound(nbt);
        VillagerData villagerData = this.read(ValueIndex.ZOMBIE_VILLAGER.VILLAGER_DATA);
        VillagerProfession profession = villagerData.getProfession();
        VillagerType type = villagerData.getType();
        int level = villagerData.getLevel();
        CompoundTag compound = new CompoundTag();
        compound.putInt("level", level);
        compound.putString("profession", profession.getName().toString());
        compound.putString("type", type.getName().toString());
        nbt.put("VillagerData", (Tag)compound);
    }
}

