/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityAnimation;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class AnimationPacketListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "animation_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.ENTITY_ANIMATION) {
            return;
        }
        WrapperPlayServerEntityAnimation wrapper = new WrapperPlayServerEntityAnimation(event);
        this.onAnimationPacket(event, wrapper);
    }

    private void onAnimationPacket(PacketSendEvent event, WrapperPlayServerEntityAnimation packet) {
        if (packet.getType() != WrapperPlayServerEntityAnimation.EntityAnimationType.WAKE_UP) {
            return;
        }
        int sourceEntityId = packet.getEntityId();
        Player sourcePlayer = this.getPlayerFrom(sourceEntityId);
        if (sourcePlayer == null) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(sourcePlayer.getUniqueId());
        if (watcher == null) {
            return;
        }
        if (event.getPlayer().equals(sourcePlayer)) {
            return;
        }
        event.setCancelled(true);
    }
}

