/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.backends.server.renderer.network.listeners;

import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityMetadata;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.backends.server.renderer.network.datawatcher.watchers.SingleWatcher;
import xyz.nifeather.morph.backends.server.renderer.network.listeners.ProtocolListener;
import xyz.nifeather.morph.backends.server.renderer.network.registries.RenderRegistry;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;

public class MetaPacketListener
extends ProtocolListener {
    @Resolved(shouldSolveImmediately=true)
    private RenderRegistry registry;

    @Override
    public String getIdentifier() {
        return "meta_listener";
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Play.Server.ENTITY_METADATA) {
            return;
        }
        WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(event);
        this.onMetaPacket(wrapper, event);
    }

    private void onMetaPacket(WrapperPlayServerEntityMetadata packet, PacketSendEvent packetEvent) {
        Player sourcePlayer = this.getPlayerFrom(packet.getEntityId());
        if (sourcePlayer == null) {
            return;
        }
        if (sourcePlayer.equals(packetEvent.getPlayer())) {
            return;
        }
        SingleWatcher watcher = this.registry.getWatcher(sourcePlayer.getUniqueId());
        if (watcher == null) {
            return;
        }
        Object targetPlayer = packetEvent.getPlayer();
        if (targetPlayer.equals(sourcePlayer)) {
            return;
        }
        WrapperPlayServerEntityMetadata wrapper = new WrapperPlayServerEntityMetadata(packetEvent);
        try {
            watcher.handleEntityMetadataPacket(wrapper);
        }
        catch (Exception e) {
            this.handleException(sourcePlayer, watcher, e);
        }
    }
}

