/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.commands.brigadier.IConvertibleBrigadier;
import xyz.nifeather.morph.commands.subcommands.OptionSubCommands;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.events.InteractionMirrorProcessor;
import xyz.nifeather.morph.messages.strings.CommandNameStrings;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigOption;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;

public class OptionSubCommand
extends MorphPluginObject
implements IConvertibleBrigadier {
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    private final List<IConvertibleBrigadier> subCommands = new CopyOnWriteArrayList<IConvertibleBrigadier>();

    @Override
    @NotNull
    public String name() {
        return "option";
    }

    public OptionSubCommand() {
        this.subCommands.add(this.getToggle("bossbar", ConfigOptions.DISPLAY_BOSSBAR, CommandNameStrings.bossbarString()));
        this.subCommands.add(this.getToggle("unmorph_on_death", ConfigOptions.UNMORPH_ON_DEATH));
        this.subCommands.add(this.getToggle("allow_client_mods", ConfigOptions.ALLOW_CLIENT));
        this.subCommands.add(this.getToggle("piglin_brute_ignore_disguises", ConfigOptions.PIGLIN_BRUTE_IGNORE_DISGUISES));
        this.subCommands.add(this.getToggle("headmorph", ConfigOptions.ALLOW_HEAD_MORPH, CommandNameStrings.headMorphString()));
        this.subCommands.add(this.getToggle("chatoverride", ConfigOptions.ALLOW_CHAT_OVERRIDE, CommandNameStrings.chatOverrideString()));
        this.subCommands.add(this.getToggle("modify_bounding_boxes", ConfigOptions.MODIFY_BOUNDING_BOX));
        this.subCommands.add(this.getToggle("force_protocol_version", ConfigOptions.FORCE_TARGET_VERSION));
        this.subCommands.add(this.getToggle("armorstand_show_arms", ConfigOptions.ARMORSTAND_SHOW_ARMS));
        this.subCommands.add(this.getMirrorMode("mirror_mode", ConfigOptions.MIRROR_SELECTION_MODE, null));
        this.subCommands.add(this.getToggle("mirror_interaction", ConfigOptions.MIRROR_BEHAVIOR_DO_SIMULATION, CommandNameStrings.mirrorInteractionString()));
        this.subCommands.add(this.getToggle("mirror_sneak", ConfigOptions.MIRROR_BEHAVIOR_SNEAK, CommandNameStrings.mirrorSneakString()));
        this.subCommands.add(this.getToggle("mirror_swaphand", ConfigOptions.MIRROR_BEHAVIOR_SWAP_HAND, CommandNameStrings.mirrorSwapHandString()));
        this.subCommands.add(this.getToggle("mirror_drop", ConfigOptions.MIRROR_BEHAVIOR_DROP, CommandNameStrings.mirrorDropString()));
        this.subCommands.add(this.getToggle("mirror_hotbar", ConfigOptions.MIRROR_BEHAVIOR_HOTBAR, CommandNameStrings.mirrorHotbar()));
        this.subCommands.add(this.getToggle("mirror_ignore_disguised", ConfigOptions.MIRROR_IGNORE_DISGUISED, CommandNameStrings.mirrorIgnoreDisguised()));
        this.subCommands.add(this.getInteger("mirror_control_distance", ConfigOptions.MIRROR_CONTROL_DISTANCE));
        this.subCommands.add(this.getToggle("mirror_log_operations", ConfigOptions.MIRROR_LOG_OPERATION));
        this.subCommands.add(this.getInteger("mirror_log_cleanup", ConfigOptions.MIRROR_LOG_CLEANUP_DATE));
        this.subCommands.add(this.getToggle("debug_output", ConfigOptions.DEBUG_OUTPUT));
        this.subCommands.add(this.getToggle("revealing", ConfigOptions.REVEALING));
        this.subCommands.add(this.getToggle("check_update", ConfigOptions.CHECK_UPDATE));
        this.subCommands.add(this.getToggle("allow_acquire_morphs", ConfigOptions.ALLOW_ACQUIRE_MORPHS));
        this.subCommands.add(this.getToggle("log_outgoing_packets", ConfigOptions.LOG_OUTGOING_PACKETS));
        this.subCommands.add(this.getToggle("log_incoming_packets", ConfigOptions.LOG_INCOMING_PACKETS));
        this.subCommands.add(this.getToggle("allow_acquire_morphs", ConfigOptions.ALLOW_ACQUIRE_MORPHS));
        this.subCommands.add(this.getToggle("allow_flight", ConfigOptions.ALLOW_FLIGHT));
        this.subCommands.add(this.getToggle("client_renderer", ConfigOptions.USE_CLIENT_RENDERER));
        this.subCommands.add(this.getList("banned_disguises", ConfigOptions.BANNED_DISGUISES, null));
        this.subCommands.add(this.getList("nofly_worlds", ConfigOptions.NOFLY_WORLDS, null));
        this.subCommands.add(this.getToggle("ability_check_permissions", ConfigOptions.DO_CHECK_ABILITY_PERMISSIONS, null));
        this.subCommands.add(this.getToggle("towny_allow_fly_in_wilderness", ConfigOptions.TOWNY_ALLOW_FLY_IN_WILDERNESS));
    }

    private IConvertibleBrigadier getList(String optionName, ConfigOption<List<String>> option, @Nullable FormattableMessage displayName) {
        return new OptionSubCommands.StringListOptionBaseCommand(optionName, this.config, option);
    }

    private IConvertibleBrigadier getMirrorMode(String name, ConfigOption<String> option, @Nullable FormattableMessage displayName) {
        return new OptionSubCommands.LimiterStringListOptionCommand(name, this.config, option, InteractionMirrorProcessor.InteractionMirrorSelectionMode.valuesLowerCase());
    }

    private IConvertibleBrigadier getInteger(String name, ConfigOption<Integer> option) {
        return this.getInteger(name, option, null);
    }

    private IConvertibleBrigadier getInteger(String name, ConfigOption<Integer> option, @Nullable FormattableMessage displayName) {
        return new OptionSubCommands.IntegerOptionCommand(name, this.config, option).min(-1);
    }

    private IConvertibleBrigadier getToggle(String name, ConfigOption<Boolean> option) {
        return this.getToggle(name, option, null);
    }

    private IConvertibleBrigadier getToggle(String name, ConfigOption<Boolean> option, @Nullable FormattableMessage displayName) {
        return new OptionSubCommands.BooleanOptionCommand(name, this.config, option);
    }

    @Override
    @Nullable
    public String permission() {
        return "feathermorph.toggle";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        LiteralArgumentBuilder thisBuilder = (LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission);
        for (IConvertibleBrigadier subCommand : this.subCommands) {
            subCommand.registerAsChild((ArgumentBuilder<CommandSourceStack, ?>)thisBuilder);
        }
        parentBuilder.then((ArgumentBuilder)thisBuilder);
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.pluginOptionDescription();
    }
}

