/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.commands.subcommands.plugin;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.commands.brigadier.BrigadierCommand;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.CommandStrings;
import xyz.nifeather.morph.messages.strings.HelpStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Messages.FormattableMessage;
import xyz.nifeather.morph.storage.offlinestore.OfflineDisguiseState;

public class QueryAllSubCommand
extends BrigadierCommand {
    @Resolved
    private MorphManager manager;

    @Override
    public String name() {
        return "queryall";
    }

    @Override
    public FormattableMessage getHelpMessage() {
        return HelpStrings.queryAllDescription();
    }

    @Override
    public String getPermissionRequirement() {
        return "feathermorph.query";
    }

    @Override
    public void registerAsChild(ArgumentBuilder<CommandSourceStack, ?> parentBuilder) {
        parentBuilder.then(((LiteralArgumentBuilder)Commands.literal((String)this.name()).requires(this::checkPermission)).executes(this::executes));
        super.registerAsChild(parentBuilder);
    }

    public int executes(CommandContext<CommandSourceStack> context) {
        List<DisguiseState> list = this.manager.getActiveDisguises();
        List<OfflineDisguiseState> offlineStates = this.manager.getAvaliableOfflineStates();
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (list.isEmpty() && offlineStates.isEmpty()) {
            MessageUtils.send(commandSender, CommandStrings.qaNoBodyDisguisingString());
            return 1;
        }
        FormattableMessage msg = CommandStrings.qaDisguisedString();
        String locale = MessageUtils.getLocale(commandSender);
        for (DisguiseState i : list) {
            Player player = i.getPlayer();
            msg.resolve("who", player.getName()).resolve("status", player.isOnline() ? CommandStrings.qaOnlineString() : CommandStrings.qaOfflineString()).resolve("what", i.getDisguiseIdentifier()).resolve("storage_status", i.showingDisguisedItems() ? CommandStrings.qaShowingDisguisedItemsString() : CommandStrings.qaNotShowingDisguisedItemsString());
            MessageUtils.send(commandSender, msg);
        }
        for (OfflineDisguiseState s : offlineStates) {
            MessageUtils.send(commandSender, msg.resolve("who", s.playerName).resolve("status", CommandStrings.qaIsOfflineStoreString()).resolve("storage_status", "").resolve("what", s.disguiseID));
        }
        return 1;
    }
}

