/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.events;

import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.CreakingHeart;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.RevealingHandler;
import xyz.nifeather.morph.api.events.gameplay.PlayerJoinedWithDisguiseEvent;
import xyz.nifeather.morph.api.networking.exceptions.PlayerDisconnectedException;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.events.PlayerFutures;
import xyz.nifeather.morph.messages.MessageUtils;
import xyz.nifeather.morph.messages.strings.MorphStrings;
import xyz.nifeather.morph.messages.vanilla.MasterVanillaMessageStore;
import xyz.nifeather.morph.misc.DisguiseEquipment;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.misc.ModNetworkingHelper;
import xyz.nifeather.morph.misc.OfflineDisguiseResult;
import xyz.nifeather.morph.misc.disguiseProperty.DisguiseProperties;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.network.Constants;
import xyz.nifeather.morph.network.commands.S2C.AbstractS2CCommand;
import xyz.nifeather.morph.network.commands.S2C.S2CSwapCommand;
import xyz.nifeather.morph.network.commands.S2C.admin.reveal.S2CRemoveAdminRevealCommand;
import xyz.nifeather.morph.network.server.MorphClientHandler;
import xyz.nifeather.morph.network.server.ServerSetEquipCommand;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;
import xyz.nifeather.morph.skills.ISkill;
import xyz.nifeather.morph.skills.SkillManager;
import xyz.nifeather.morph.storage.offlinestore.OfflineDisguiseState;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.EntityTypeUtils;

public class CommonEventProcessor
extends MorphPluginObject
implements Listener {
    @Resolved(shouldSolveImmediately=true)
    private MorphManager morphs;
    @Resolved(shouldSolveImmediately=true)
    private MorphConfigManager config;
    @Resolved(shouldSolveImmediately=true)
    private SkillManager skillHandler;
    @Resolved(shouldSolveImmediately=true)
    private MasterVanillaMessageStore masterVanillaMessageStore;
    @Resolved(shouldSolveImmediately=true)
    private RevealingHandler revealingHandler;
    private final Bindable<Boolean> unMorphOnDeath = new Bindable<Boolean>(true);
    private final Bindable<Boolean> doRevealing = new Bindable<Boolean>(true);
    private final Bindable<Boolean> allowAcquireMorphs = new Bindable<Boolean>(false);
    private final Bindable<Integer> cooldownOnDamage = new Bindable<Integer>(0);
    private final Bindable<Boolean> bruteIgnoreDisguises = new Bindable<Boolean>(true);
    @Resolved(shouldSolveImmediately=true)
    private ModNetworkingHelper modNetworkingHelper;
    @Resolved(shouldSolveImmediately=true)
    private MorphClientHandler clientHandler;
    private final List<Player> playersMinedGoldBlocks = Collections.synchronizedList(new ObjectArrayList());

    @Initializer
    private void load() {
        this.config.bind(this.cooldownOnDamage, ConfigOptions.SKILL_COOLDOWN_ON_DAMAGE);
        this.config.bind(this.bruteIgnoreDisguises, ConfigOptions.PIGLIN_BRUTE_IGNORE_DISGUISES);
        this.config.bind(this.doRevealing, ConfigOptions.REVEALING);
        this.config.bind(this.allowAcquireMorphs, ConfigOptions.ALLOW_ACQUIRE_MORPHS);
        this.config.bind(this.unMorphOnDeath, ConfigOptions.UNMORPH_ON_DEATH);
        this.addSchedule(this::update);
    }

    private void update() {
        this.addSchedule(this::update);
        if (this.plugin.getCurrentTick() % 8L == 0L) {
            this.playersMinedGoldBlocks.clear();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChannelRegister(PlayerRegisterChannelEvent event) {
        if (this.featherMorph().debugOutputEnabled()) {
            this.logger.info("Player registered channel %s".formatted(event.getChannel()));
        }
        if (event.getChannel().startsWith(FeatherMorphMain.getMorphNameSpace())) {
            this.clientHandler.onPlayerChannelRegister(event.getPlayer());
        }
    }

    @EventHandler
    public void onEntityAddToWorld(EntityAddToWorldEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        World world = e.getWorld();
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        if (state != null && this.morphs.disguiseDisabledInWorld(world)) {
            this.scheduleOn((Entity)player, () -> {
                if (!player.getWorld().equals((Object)world)) {
                    return;
                }
                MessageUtils.send((CommandSender)player, MorphStrings.disguiseDisabledInWorldString());
                this.morphs.unMorph(player);
            });
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        EntityDamageByEntityEvent damageEvent;
        Entity cause;
        EntityDamageEvent lastCause;
        LivingEntity entity = e.getEntity();
        Player killer = entity.getKiller();
        if (entity.getType() == EntityType.ARMOR_STAND && (lastCause = entity.getLastDamageCause()) instanceof EntityDamageByEntityEvent && (cause = (damageEvent = (EntityDamageByEntityEvent)lastCause).getDamager()) instanceof Player) {
            killer = (Player)cause;
        }
        if (killer != null && !killer.equals((Object)entity)) {
            this.onPlayerKillEntity(killer, (Entity)e.getEntity());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        if (this.unMorphOnDeath.get().booleanValue()) {
            this.morphs.unMorph((CommandSender)e.getPlayer(), e.getPlayer(), true, true);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerPostRespawnEvent e) {
        DisguiseState state = this.morphs.getDisguiseStateFor(e.getPlayer());
        if (state != null) {
            state.getAbilityUpdater().reApplyAbility();
            ISkill<?> skill = state.getSkill();
            skill.onInitialEquip(state);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerTookDamage(EntityDamageEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        if (state != null) {
            state.getSoundHandler().resetSoundTime();
            if (e.getDamage() > 0.0) {
                state.setSkillCooldown(Math.max(state.calculateRemainingCooldown(), (long)this.cooldownOnDamage.get().intValue()), true);
            }
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent e) {
        Player clickedPlayer;
        DisguiseState state;
        Entity entity = e.getRightClicked();
        if (entity instanceof Player && (state = this.morphs.getDisguiseStateFor(clickedPlayer = (Player)entity)) != null) {
            if (state.getEntityType() == EntityType.ALLAY) {
                e.setCancelled(true);
            }
            if (EntityTypeUtils.saddleable(state.getDisguiseWrapper().getEntityType())) {
                EquipmentSlot slot = e.getHand();
                ItemStack item = e.getPlayer().getEquipment().getItem(slot);
                if (item.getType() == Material.SADDLE) {
                    state.getDisguiseWrapper().setSaddled(true);
                } else if (item.getType() != Material.AIR) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerSwapHand(PlayerSwapHandItemsEvent e) {
        Player player = e.getPlayer();
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        if (!state.showingDisguisedItems()) {
            return;
        }
        DisguiseEquipment equip = state.getDisguiseEquipment();
        ItemStack mainHand = DisguiseUtils.itemOrAir(equip.getItemInMainHand());
        ItemStack offHand = DisguiseUtils.itemOrAir(equip.getItemInOffHand());
        if (this.clientHandler.isFutureClientProtocol(player, 3)) {
            if (!this.clientHandler.isFutureClientProtocol(player, Constants.ApiLevel.EQUIPMENT_AND_SKIN_ARE_NOW_PROPERTY.protocolVersion)) {
                this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new S2CSwapCommand());
            }
        } else {
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new ServerSetEquipCommand(mainHand, EquipmentSlot.HAND));
            this.clientHandler.sendCommand(player, (AbstractS2CCommand<?>)new ServerSetEquipCommand(offHand, EquipmentSlot.OFF_HAND));
        }
        PropertyHandler propertyHandler = state.disguisePropertyHandler();
        BaseLivingEntityPropertyCollection properties = DisguiseProperties.INSTANCE.getCollectionOrThrow(BaseLivingEntityPropertyCollection.class);
        DisguiseEquipment newEquipment = DisguiseEquipment.builder(equip).offHand(mainHand).mainHand(offHand).build();
        propertyHandler.set(properties.EQUIPMENT, newEquipment);
    }

    @EventHandler
    public void onClientOptionChanged(PlayerClientOptionsChangeEvent e) {
        Player player;
        DisguiseState state;
        String locale = e.getLocale().toLowerCase(Locale.ROOT);
        this.masterVanillaMessageStore.getOrCreateSubStore(locale);
        if (e.hasLocaleChanged() && (state = this.morphs.getDisguiseStateFor(player = e.getPlayer())) != null && state.entityCustomName == null) {
            Component displayName = state.getProvider().getDisplayName(state.getDisguiseIdentifier(), locale);
            state.setPlayerDisplay(displayName);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        PlayerFutures.complete(player);
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        ObjectOpenHashSet effectivePermissions = new ObjectOpenHashSet((Collection)player.getEffectivePermissions());
        ObjectArrayList legacyPermissions = new ObjectArrayList();
        effectivePermissions.forEach(arg_0 -> CommonEventProcessor.lambda$onPlayerJoin$1((List)legacyPermissions, arg_0));
        if (!legacyPermissions.isEmpty()) {
            this.logger.error("- x - x - x - x - x - x - x - x - x - x - x - x -");
            this.logger.error("MAY I HAVE YOUR ATTENTION PLEASE!");
            this.logger.error("");
            this.logger.error("Found legacy permission set for player '%s'!".formatted(player.getName()));
            this.logger.error("Please migrate to the new prefix 'feathermorph.XXX' instead of 'xiamomc.morph.XXX', as legacy permission support is now ENDED!");
            this.logger.error("Permissions found:");
            legacyPermissions.forEach(p -> this.logger.error("  --> %s".formatted(p)));
            this.logger.error("");
            this.logger.error("- x - x - x - x - x - x - x - x - x - x - x - x -");
        }
        if (state != null) {
            state.onPlayerJoin();
            this.modNetworkingHelper.sendCommandToRevealablePlayers(this.modNetworkingHelper.genPartialMapCommand(state));
            new PlayerJoinedWithDisguiseEvent(player, state).callEvent();
            return;
        }
        OfflineDisguiseState offlineState = this.morphs.getOfflineState(player);
        if (offlineState != null) {
            MessageUtils.send((CommandSender)player, MorphStrings.stateRecoverReasonString());
            OfflineDisguiseResult result = this.morphs.disguiseFromOfflineState(player, offlineState);
            if (result == OfflineDisguiseResult.SUCCESS) {
                MessageUtils.send((CommandSender)player, MorphStrings.recoveringStateString());
            } else if (result == OfflineDisguiseResult.LIMITED) {
                MessageUtils.send((CommandSender)player, MorphStrings.recoveringStateLimitedString());
                MessageUtils.send((CommandSender)player, MorphStrings.recoveringStateLimitedHintString());
            } else {
                MessageUtils.send((CommandSender)player, MorphStrings.recoveringFailedString());
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        DisguiseState state = this.morphs.getDisguiseStateFor(e.getPlayer());
        if (state == null) {
            return;
        }
        state.waypointTransmitter().updateRealtimeConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    public void onPlayerExit(PlayerQuitEvent e) {
        ObjectArrayList players;
        this.clientHandler.disconnect(e.getPlayer(), new PlayerDisconnectedException("Player disconnected"));
        this.skillHandler.trim();
        DisguiseState state = this.morphs.getDisguiseStateFor(e.getPlayer());
        CommonEventProcessor commonEventProcessor = this;
        synchronized (commonEventProcessor) {
            players = new ObjectArrayList(this.featherMorph().getPlatform().onlinePlayersNative());
        }
        if (state != null) {
            BossBar bossbar = state.getBossbar();
            if (bossbar != null) {
                players.forEach(p -> p.hideBossBar(bossbar));
            }
            state.onPlayerQuit();
        }
        List<Player> targets = players.stream().filter(p -> p.hasPermission("feathermorph.disguise_revealing")).toList();
        S2CRemoveAdminRevealCommand cmd = new S2CRemoveAdminRevealCommand(e.getPlayer().getEntityId());
        targets.forEach(p -> this.clientHandler.sendCommand((Player)p, (AbstractS2CCommand<?>)cmd));
    }

    @EventHandler
    public void onPlayerWorldChange(PlayerChangedWorldEvent e) {
        Player player = e.getPlayer();
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        if (state != null) {
            ISkill<?> skill = state.getSkill();
            skill.onInitialEquip(state);
            state.getAbilityUpdater().reApplyAbility();
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent e) {
        DisguiseState state = this.morphs.getDisguiseStateFor(e.getPlayer());
        if (state == null) {
            return;
        }
        if (e.getBlock().getType().equals((Object)Material.GOLD_BLOCK)) {
            this.playersMinedGoldBlocks.add(e.getPlayer());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent e) {
        EntityDamageByEntityEvent edbee;
        Entity entity;
        if (e.getTarget() == null) {
            return;
        }
        EntityType sourceEntityType = e.getEntityType();
        if (sourceEntityType == EntityType.PIGLIN_BRUTE && this.bruteIgnoreDisguises.get().booleanValue()) {
            return;
        }
        if (sourceEntityType == EntityType.WARDEN || !((entity = e.getTarget()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (sourceEntityType == EntityType.PIGLIN && this.playersMinedGoldBlocks.contains(player)) {
            return;
        }
        EntityDamageEvent entityDamageEvent = e.getEntity().getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent && (edbee = (EntityDamageByEntityEvent)entityDamageEvent).getDamager().equals((Object)player)) {
            return;
        }
        switch (e.getReason()) {
            case TARGET_ATTACKED_ENTITY: 
            case TARGET_ATTACKED_NEARBY_ENTITY: 
            case REINFORCEMENT_TARGET: 
            case FOLLOW_LEADER: 
            case DEFEND_VILLAGE: 
            case TARGET_ATTACKED_OWNER: 
            case OWNER_ATTACKED_TARGET: 
            case CUSTOM: 
            case UNKNOWN: {
                return;
            }
        }
        DisguiseState state = this.morphs.getDisguiseStateFor(player);
        if (state == null) {
            return;
        }
        EntityType disguiseEntityType = state.getEntityType();
        boolean shouldTarget = switch (sourceEntityType) {
            case EntityType.ZOMBIE, EntityType.ZOMBIE_VILLAGER, EntityType.HUSK, EntityType.DROWNED -> EntityTypeUtils.isZombiesHostile(disguiseEntityType);
            case EntityType.SKELETON, EntityType.STRAY -> {
                if (EntityTypeUtils.isGolem(disguiseEntityType) || state.getEntityType() == EntityType.PLAYER) {
                    yield true;
                }
                yield false;
            }
            case EntityType.PIGLIN -> EntityTypeUtils.isPiglinHostile(disguiseEntityType);
            case EntityType.PIGLIN_BRUTE -> EntityTypeUtils.isBruteHostile(disguiseEntityType);
            case EntityType.WITHER_SKELETON -> EntityTypeUtils.isWitherSkeletonHostile(disguiseEntityType);
            case EntityType.GUARDIAN, EntityType.ELDER_GUARDIAN -> EntityTypeUtils.isGuardianHostile(disguiseEntityType);
            case EntityType.WITHER -> EntityTypeUtils.isWitherHostile(disguiseEntityType);
            case EntityType.PILLAGER, EntityType.VEX, EntityType.ILLUSIONER, EntityType.VINDICATOR, EntityType.EVOKER, EntityType.RAVAGER -> EntityTypeUtils.isRaiderHostile(disguiseEntityType);
            case EntityType.ENDERMAN -> {
                if (disguiseEntityType == EntityType.PLAYER || disguiseEntityType == EntityType.ENDERMITE) {
                    yield true;
                }
                yield false;
            }
            case EntityType.ZOGLIN -> EntityTypeUtils.isZoglinHostile(disguiseEntityType);
            default -> state.getEntityType() == EntityType.PLAYER;
        };
        RevealingHandler.RevealingState revealingState = this.revealingHandler.getRevealingState(player);
        if (this.doRevealing.get().booleanValue()) {
            revealingState.addBaseValue(0.36f);
        }
        shouldTarget = shouldTarget || revealingState.shouldMobsAwareRevealed();
        e.setCancelled(!shouldTarget);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onAdvancement(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.CREAKING_HEART) {
            return;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof CreakingHeart)) {
            return;
        }
        CreakingHeart creakingHeart = (CreakingHeart)blockData;
        if (creakingHeart.getCreakingHeartState() != CreakingHeart.State.AWAKE || !creakingHeart.isNatural()) {
            return;
        }
        this.morphs.grantMorphToPlayer(event.getPlayer(), EntityType.CREAKING.getKey().asString());
    }

    private void onPlayerKillEntity(Player player, Entity entity) {
        if (!(entity instanceof LivingEntity) && entity.getType() != EntityType.ARMOR_STAND) {
            return;
        }
        if (!this.allowAcquireMorphs.get().booleanValue()) {
            return;
        }
        if (entity.getScoreboardTags().contains("feathermorph_nogrant")) {
            return;
        }
        if (entity instanceof Player) {
            Player targetPlayer = (Player)entity;
            this.morphs.grantMorphToPlayer(player, DisguiseTypes.PLAYER.toId(targetPlayer.getName()));
        } else {
            EntityType type = entity.getType();
            if (type != EntityType.CREAKING) {
                this.morphs.grantMorphToPlayer(player, type.getKey().asString());
            }
        }
    }

    private static /* synthetic */ void lambda$onPlayerJoin$1(List legacyPermissions, PermissionAttachmentInfo permInfo) {
        String name = permInfo.getPermission();
        if (!name.startsWith("xiamomc.morph")) {
            return;
        }
        legacyPermissions.add(name);
    }
}

