/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.Pair;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import xyz.nifeather.morph.misc.actions.BiConsumerActions;
import xyz.nifeather.morph.misc.actions.ConsumerActions;

public class ConfirmationHandler<E> {
    private final Map<E, Long> confirmationMap = new ConcurrentHashMap<E, Long>();
    private final BiConsumerActions<E, Duration> onSubmit = new BiConsumerActions();
    private final ConsumerActions<E> onExpire = new ConsumerActions();

    public BiConsumerActions<E, Duration> onSubmit() {
        return this.onSubmit;
    }

    public ConsumerActions<E> onExpire() {
        return this.onExpire;
    }

    public boolean contains(E handle) {
        return this.confirmationMap.containsKey(handle);
    }

    public void submit(E handle, Duration duration) {
        long time = System.currentTimeMillis() + duration.toMillis();
        this.confirmationMap.put(handle, time);
        this.onSubmit.invoke(Pair.of(handle, (Object)duration));
    }

    public boolean confirm(E handle) {
        return this.confirmationMap.remove(handle) != null;
    }

    public boolean expire(E handle) {
        if (!this.contains(handle)) {
            return false;
        }
        this.confirmationMap.remove(handle);
        this.onExpire.invoke(handle);
        return true;
    }

    public void update() {
        long current = System.currentTimeMillis();
        ImmutableMap map = ImmutableMap.copyOf(this.confirmationMap);
        map.forEach((e, time) -> {
            if (current > time) {
                this.expire(e);
            }
        });
    }
}

