/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import xyz.nifeather.morph.misc.disguiseProperty.IPropertyValidator;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandle;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidationException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyValidations;
import xyz.nifeather.morph.misc.disguiseProperty.ValidationFlag;

public record SingleProperty<T>(String identifier, T defaultVal, Class<T> type, InputHandle<T> inputHandle, OutputHandle<T> outputHandle, IPropertyValidator<T> propertyValidator, List<T> randomValues, List<String> suggestions, boolean hideFromUserInput, boolean hideFromClient) {
    private final List<T> randomValues;

    public SingleProperty(String identifier, T defaultVal, Class<T> type, @NotNull InputHandle<T> inputHandle, @NotNull OutputHandle<T> outputHandle, @NotNull IPropertyValidator<T> propertyValidator, List<T> randomValues, List<String> suggestions, boolean hideFromUserInput, boolean hideFromClient) {
        this.identifier = identifier;
        this.defaultVal = defaultVal;
        this.type = type;
        this.inputHandle = inputHandle;
        this.outputHandle = outputHandle;
        this.propertyValidator = propertyValidator;
        this.hideFromUserInput = hideFromUserInput;
        this.hideFromClient = hideFromClient;
        this.randomValues = ImmutableList.copyOf(randomValues);
        this.suggestions = ImmutableList.copyOf(suggestions);
    }

    public String id() {
        return this.identifier;
    }

    public Optional<T> forInput(String input) throws ParseErrorException {
        return this.inputHandle.handle(this.id(), input);
    }

    @NotNull
    public String forValue(T value) throws ParseErrorException {
        return this.outputHandle.handle(this.id(), value);
    }

    public void validateInput(T value, Player player, EnumSet<ValidationFlag> validationFlags) throws PropertyValidationException {
        this.propertyValidator.validate(value, player, validationFlags);
    }

    public @Unmodifiable List<String> validInputs() {
        return new ObjectArrayList(this.suggestions);
    }

    public @Unmodifiable List<T> randomValues() {
        return new ObjectArrayList(this.randomValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SingleProperty)) {
            return false;
        }
        SingleProperty other = (SingleProperty)obj;
        return this.identifier.equals(other.identifier) && this.type.equals(other.type);
    }

    public static <X> SinglePropertyBuilder<X> builder(String id, X defaultVal) {
        return new SinglePropertyBuilder(id, defaultVal.getClass(), defaultVal);
    }

    public static <X> SinglePropertyBuilder<X> builder(String id, Class<X> type, X defaultVal) {
        return new SinglePropertyBuilder<X>(id, type, defaultVal);
    }

    public static class SinglePropertyBuilder<X> {
        private final String identifier;
        private final X defaultVal;
        private final Class<X> type;
        private InputHandle<X> inputHandle = InputHandles::empty;
        private OutputHandle<X> outputHandle = OutputHandles::immediateException;
        private IPropertyValidator<X> validator = PropertyValidations::noOp;
        private boolean hideFromUserInput = false;
        private boolean hideFromClient = false;
        private final List<X> randomValues = new ObjectArrayList();
        private final List<String> suggestions = new ObjectArrayList();

        public SinglePropertyBuilder(String identifier, Class<X> type, X defaultVal) {
            this.identifier = identifier;
            this.type = type;
            this.defaultVal = defaultVal;
        }

        public SinglePropertyBuilder<X> withInputHandle(InputHandle<X> handle) {
            this.inputHandle = handle;
            return this;
        }

        public SinglePropertyBuilder<X> withOutputHandle(OutputHandle<X> handle) {
            this.outputHandle = handle;
            return this;
        }

        public SinglePropertyBuilder<X> withValidator(IPropertyValidator<X> validator) {
            this.validator = validator;
            return this;
        }

        public SinglePropertyBuilder<X> hideFromUserInput(boolean hideFromUserInput) {
            this.hideFromUserInput = hideFromUserInput;
            return this;
        }

        public SinglePropertyBuilder<X> hideFromClient(boolean hideFromClient) {
            this.hideFromClient = hideFromClient;
            return this;
        }

        @SafeVarargs
        public final SinglePropertyBuilder<X> withRandom(X ... values) {
            this.randomValues.addAll(Arrays.stream(values).toList());
            return this;
        }

        public SinglePropertyBuilder<X> withRandom(Collection<X> values) {
            this.randomValues.addAll(values);
            return this;
        }

        public SinglePropertyBuilder<X> withSuggestions(String ... values) {
            this.suggestions.addAll(Arrays.stream(values).toList());
            return this;
        }

        public SinglePropertyBuilder<X> withSuggestions(Collection<String> values) {
            this.suggestions.addAll(values);
            return this;
        }

        public SingleProperty<X> build() {
            return new SingleProperty<X>(this.identifier, this.defaultVal, this.type, this.inputHandle, this.outputHandle, this.validator, this.randomValues, this.suggestions, this.hideFromUserInput, this.hideFromClient);
        }
    }
}

