/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;
import xyz.nifeather.morph.utilities.Uuids;

public class CatPropertyCollection
extends BaseLivingEntityPropertyCollection<Cat> {
    private final Map<String, Cat.Type> variantMap = new ConcurrentHashMap<String, Cat.Type>();
    public final SingleProperty<Cat.Type> CAT_VARIANT;
    public final SingleProperty<UUID> OWNER = SingleProperty.builder("cat/owner", Uuids.NIL_UUID).withInputHandle(InputHandles::readUUID).withOutputHandle(OutputHandles::writeUUID).build();
    public final SingleProperty<DyeColor> COLLAR_COLOR;

    private void initVariantMap() {
        for (Cat.Type variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.CAT_VARIANT)) {
            this.variantMap.put(variant.key().asString(), variant);
        }
    }

    private Optional<Cat.Type> readCatVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.CAT_VARIANT, propertyName, string);
    }

    public CatPropertyCollection() {
        this.initVariantMap();
        this.CAT_VARIANT = SingleProperty.builder("cat/variant", Cat.Type.TABBY).withInputHandle(this::readCatVariant).withOutputHandle(OutputHandles::writeKeyed).withSuggestions(this.variantMap.keySet()).withRandom(this.variantMap.values()).build();
        this.COLLAR_COLOR = SingleProperty.builder("cat/collar_color", DyeColor.RED).withInputHandle(InputHandles::readDyeColor).withOutputHandle(OutputHandles::writeEnum).withSuggestions(Arrays.stream(DyeColor.values()).map(c -> c.name().toLowerCase()).toList()).build();
        this.registerSingle(this.CAT_VARIANT, this.OWNER, this.COLLAR_COLOR);
    }

    @Override
    @Nullable
    protected Cat tryCastEntity(@Nullable Entity targetEntity) {
        Cat cat;
        return targetEntity instanceof Cat ? (cat = (Cat)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Cat cat) {
        super.setupPropertiesFromEntity(meta, propertyHandler, cat);
        propertyHandler.set(this.CAT_VARIANT, cat.getCatType());
        propertyHandler.set(this.COLLAR_COLOR, cat.getCollarColor());
        if (cat.getOwnerUniqueId() != null) {
            propertyHandler.set(this.OWNER, cat.getOwnerUniqueId());
        }
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.CAT_VARIANT, DisguiseUtils.pick(this.CAT_VARIANT.randomValues()));
    }
}

