/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Frog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class FrogPropertyCollection
extends BaseLivingEntityPropertyCollection<Frog> {
    private final Map<String, Frog.Variant> variantMap = new ConcurrentHashMap<String, Frog.Variant>();
    public final SingleProperty<Frog.Variant> VARIANT;

    private void initMap() {
        for (Frog.Variant variant : RegistryAccess.registryAccess().getRegistry(RegistryKey.FROG_VARIANT).stream().toList()) {
            this.variantMap.put(variant.key().asString(), variant);
        }
    }

    private Optional<Frog.Variant> readFrogVariant(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readRegistry(RegistryKey.FROG_VARIANT, propertyName, string);
    }

    public FrogPropertyCollection() {
        this.initMap();
        this.VARIANT = SingleProperty.builder("frog/variant", Frog.Variant.TEMPERATE).withInputHandle(this::readFrogVariant).withOutputHandle(OutputHandles::writeKeyed).withRandom((Frog.Variant[])new Frog.Variant[]{Frog.Variant.TEMPERATE, Frog.Variant.COLD, Frog.Variant.WARM}).withSuggestions(this.variantMap.keySet()).build();
        this.registerSingle((SingleProperty<?>)this.VARIANT);
    }

    @Override
    @Nullable
    protected Frog tryCastEntity(@Nullable Entity targetEntity) {
        Frog frog;
        return targetEntity instanceof Frog ? (frog = (Frog)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Frog frog) {
        super.setupPropertiesFromEntity(meta, propertyHandler, frog);
        propertyHandler.set(this.VARIANT, frog.getVariant());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.VARIANT, DisguiseUtils.pick(this.VARIANT.randomValues()));
    }
}

