/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.disguiseProperty.values;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Llama;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.disguiseProperty.InputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.OutputHandles;
import xyz.nifeather.morph.misc.disguiseProperty.ParseErrorException;
import xyz.nifeather.morph.misc.disguiseProperty.PropertyHandler;
import xyz.nifeather.morph.misc.disguiseProperty.SingleProperty;
import xyz.nifeather.morph.misc.disguiseProperty.values.BaseLivingEntityPropertyCollection;
import xyz.nifeather.morph.utilities.DisguiseUtils;

public class LlamaPropertyCollection
extends BaseLivingEntityPropertyCollection<Llama> {
    private final Map<String, Llama.Color> colorMap = new ConcurrentHashMap<String, Llama.Color>();
    public final SingleProperty<Llama.Color> COLOR;

    private void initMaps() {
        for (Llama.Color value : Llama.Color.values()) {
            this.colorMap.put(value.name().toLowerCase(), value);
        }
    }

    private Optional<Llama.Color> readLlamaColor(String propertyName, String string) throws ParseErrorException {
        return InputHandles.readEnumNonNull((Enum[])Llama.Color.values(), (String)propertyName, (String)string);
    }

    public LlamaPropertyCollection() {
        this.initMaps();
        this.COLOR = SingleProperty.builder("llama/color", Llama.Color.CREAMY).withInputHandle(this::readLlamaColor).withOutputHandle(OutputHandles::writeEnum).withRandom((Llama.Color[])Llama.Color.values()).withSuggestions(this.colorMap.keySet()).build();
        this.registerSingle((SingleProperty<?>)this.COLOR);
    }

    @Override
    @Nullable
    protected Llama tryCastEntity(@Nullable Entity targetEntity) {
        Llama llama;
        return targetEntity instanceof Llama ? (llama = (Llama)targetEntity) : null;
    }

    @Override
    protected void setupPropertiesFromEntity(DisguiseMeta meta, PropertyHandler propertyHandler, @NotNull Llama llama) {
        super.setupPropertiesFromEntity(meta, propertyHandler, llama);
        propertyHandler.set(this.COLOR, llama.getColor());
    }

    @Override
    protected void setupDefaultProperties(PropertyHandler propertyHandler) {
        propertyHandler.set(this.COLOR, DisguiseUtils.pick(this.COLOR.randomValues()));
    }
}

