/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.misc.gui;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import xyz.nifeather.morph.messages.strings.EmoteStrings;
import xyz.nifeather.morph.messages.strings.GuiStrings;
import xyz.nifeather.morph.misc.DisguiseState;
import xyz.nifeather.morph.misc.gui.IconLookup;
import xyz.nifeather.morph.misc.gui.ScreenWrapper;
import xyz.nifeather.morph.providers.animation.AnimationSet;
import xyz.nifeather.morph.providers.animation.SingleAnimation;
import xyz.nifeather.morph.shaded.inventorygui.GuiElement;
import xyz.nifeather.morph.shaded.inventorygui.GuiElementGroup;
import xyz.nifeather.morph.shaded.inventorygui.InventoryGui;
import xyz.nifeather.morph.shaded.inventorygui.StaticGuiElement;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.BindableList;

public class AnimSelectScreenWrapper
extends ScreenWrapper {
    private final BindableList<String> pattern = new BindableList<String>(List.of("XXXXE"));
    private final DisguiseState state;
    private final List<String> availableSequences;

    private List<String> getTemplate() {
        return this.pattern;
    }

    public AnimSelectScreenWrapper(DisguiseState state, List<String> availableSequences) {
        super(state.getPlayer());
        this.state = state;
        this.availableSequences = availableSequences;
        this.guiInstance = this.preparePage();
        this.initElements(this.guiInstance);
    }

    @Override
    public void show() {
        this.getBindingPlayer().playSound(openSound);
        super.show();
    }

    protected void parseItemLore(ItemMeta itemMeta, List<String> strings) {
        ObjectArrayList loreList = new ObjectArrayList();
        strings.forEach(arg_0 -> this.lambda$parseItemLore$0((List)loreList, arg_0));
        itemMeta.lore((List)loreList);
    }

    protected void parseItemName(ItemMeta itemMeta, String s) {
        TextComponent component = Component.text((String)"???");
        try {
            component = MiniMessage.miniMessage().deserialize((Object)s);
        }
        catch (Throwable t) {
            this.logger.error("Can't deserialize string '%s': %s".formatted(s, t.getMessage()));
        }
        itemMeta.itemName((Component)component);
    }

    private InventoryGui preparePage() {
        List<String> template = this.getTemplate();
        if (template.size() > 6) {
            this.logger.error("May not have a inventory with more than 6 rows.");
            return new InventoryGui((Plugin)this.plugin, "missingno", new String[]{"         "}, new GuiElement[0]);
        }
        ObjectArrayList rows = new ObjectArrayList();
        for (String line : template) {
            rows.add(line.toUpperCase());
        }
        String[] array = rows.toArray(new String[0]);
        InventoryGui skel = new InventoryGui((Plugin)this.plugin, GuiStrings.selectAnimation().createString(this.playerLocale), array, new GuiElement[0]);
        skel.setItemNameSetter(this::parseItemName);
        skel.setItemLoreSetter(this::parseItemLore);
        skel.setCloseAction(close -> false);
        return skel;
    }

    private void initElements(InventoryGui gui) {
        ItemStack defaultIcon = IconLookup.instance().lookup(this.state.getDisguiseIdentifier());
        if (IconLookup.instance().lookup(this.state.getDisguiseIdentifier()).getType() == Material.PLAYER_HEAD) {
            this.isDynamic.set(true);
        }
        GuiElementGroup groupElement = new GuiElementGroup('X', new GuiElement[0]);
        ItemStack filler = ItemStack.of((Material)Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        filler.editMeta(meta -> {
            Component name = EmoteStrings.none().createComponent(this.playerLocale).style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
            meta.customName(name);
        });
        groupElement.setFiller(filler);
        for (String sequenceId : this.availableSequences) {
            ItemStack icon = defaultIcon.clone();
            icon.editMeta(meta -> {
                Component name = EmoteStrings.get(sequenceId).createComponent().style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
                meta.setRarity(ItemRarity.COMMON);
                meta.customName(name);
            });
            StaticGuiElement element = new StaticGuiElement('_', icon, 1 + this.availableSequences.indexOf(sequenceId), click -> {
                AnimationSet animationSet = this.state.getProvider().getAnimationProvider().getAnimationSetFor(this.state.getDisguiseIdentifier());
                Pair<List<SingleAnimation>, Boolean> sequencePair = animationSet.sequenceOf(sequenceId);
                this.getBindingPlayer().playSound(clickSound);
                this.state.tryScheduleSequence(sequenceId, (List)sequencePair.left(), (Boolean)sequencePair.right());
                this.guiInstance.close();
                return true;
            }, new String[0]);
            groupElement.addElement(element);
        }
        gui.addElement(groupElement);
        gui.addElement(new StaticGuiElement('!', new ItemStack(Material.PINK_STAINED_GLASS_PANE), 1, click -> true, "<italic:false>"));
        ItemStack closeElementItem = new ItemStack(Material.MAGENTA_GLAZED_TERRACOTTA);
        closeElementItem.editMeta(meta -> meta.setRarity(ItemRarity.COMMON));
        gui.addElement(new StaticGuiElement('E', closeElementItem, 1, click -> {
            this.getBindingPlayer().playSound(clickSound);
            this.guiInstance.close();
            return true;
        }, "<italic:false>" + GuiStrings.close().createString(this.playerLocale)));
    }

    private /* synthetic */ void lambda$parseItemLore$0(List loreList, String lore) {
        TextComponent component = Component.text((String)"???");
        try {
            component = MiniMessage.miniMessage().deserialize((Object)lore);
        }
        catch (Throwable t) {
            this.logger.error("Can't deserialize lore string '%s': %s".formatted(lore, t.getMessage()));
        }
        loreList.add(component);
    }
}

