/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance;

import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.MorphManager;
import xyz.nifeather.morph.MorphPluginObject;
import xyz.nifeather.morph.config.ConfigOptions;
import xyz.nifeather.morph.config.MorphConfigManager;
import xyz.nifeather.morph.network.multiInstance.master.MasterInstance;
import xyz.nifeather.morph.network.multiInstance.protocol.Operation;
import xyz.nifeather.morph.network.multiInstance.protocol.SocketPlayerMeta;
import xyz.nifeather.morph.network.multiInstance.protocol.c2s.MIC2SSyncDisguiseCommand;
import xyz.nifeather.morph.network.multiInstance.protocol.s2c.MIS2CUpdateMetaCommand;
import xyz.nifeather.morph.network.multiInstance.slave.SlaveInstance;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Initializer;
import xyz.nifeather.morph.shaded.pluginbase.Annotations.Resolved;
import xyz.nifeather.morph.shaded.pluginbase.Bindables.Bindable;

public class MultiInstanceService
extends MorphPluginObject {
    @Nullable
    private MasterInstance masterInstance;
    @Nullable
    private SlaveInstance slaveInstance;
    @Resolved
    private MorphManager manager;
    private final Bindable<Boolean> isMaster = new Bindable<Boolean>(false);
    private final Bindable<Boolean> enabled = new Bindable<Boolean>(false);

    @Nullable
    public MasterInstance masterInstance() {
        return this.masterInstance;
    }

    @Nullable
    public SlaveInstance slaveInstance() {
        return this.slaveInstance;
    }

    private void checkSanity() {
        if (this.masterInstance == null && this.slaveInstance == null) {
            throw new IllegalStateException("None of master or slave instance is present!");
        }
        if (this.isMaster.get().booleanValue() && this.masterInstance == null) {
            throw new IllegalStateException("We are the master server, but the server instance is null?!");
        }
        if (!this.isMaster.get().booleanValue() && this.slaveInstance == null) {
            throw new IllegalStateException("We are the client, but the client instance is null?!");
        }
    }

    private void prepareInstance(boolean isMaster) {
        this.logger.info("Preparing socket instance...");
        if (!this.stopAll()) {
            this.logger.warn("Can't stop instance, not continuing...");
            this.masterInstance = null;
            this.slaveInstance = null;
            return;
        }
        this.masterInstance = null;
        this.slaveInstance = null;
        if (isMaster) {
            this.masterInstance = new MasterInstance();
        } else {
            this.slaveInstance = new SlaveInstance(true);
        }
    }

    @Initializer
    private void load(MorphConfigManager configManager) {
        configManager.bind(this.enabled, ConfigOptions.ENABLE_MULTIINSTANCE);
        configManager.bind(this.isMaster, ConfigOptions.IS_MASTER);
        this.isMaster.onValueChanged((o, n) -> {
            if (this.enabled.get().booleanValue()) {
                this.prepareInstance((boolean)n);
            }
        }, true);
    }

    public void onDisable() {
        this.stopAll();
    }

    public void notifyDisguiseMetaChange(UUID uuid, Operation operation, String ... identifiers) {
        if (!this.enabled.get().booleanValue()) {
            return;
        }
        try {
            this.checkSanity();
        }
        catch (Throwable t) {
            this.logger.error("Sanity check failed", t);
            return;
        }
        SocketPlayerMeta meta = new SocketPlayerMeta(operation, Arrays.stream(identifiers).toList(), uuid);
        if (this.isMaster.get().booleanValue()) {
            assert (this.masterInstance != null);
            this.masterInstance.broadcastCommand(new MIS2CUpdateMetaCommand(meta));
        } else {
            assert (this.slaveInstance != null);
            if (this.slaveInstance.isOnline()) {
                this.slaveInstance.sendCommand(new MIC2SSyncDisguiseCommand(meta));
            }
        }
    }

    public void onReload() {
        this.stopAll();
        if (this.enabled.get().booleanValue()) {
            this.addSchedule(() -> this.prepareInstance(this.isMaster.get()), 20);
        } else if (this.slaveInstance != null) {
            this.slaveInstance.resetDataStore();
        }
    }

    private boolean stopAll() {
        boolean success = true;
        if (this.slaveInstance != null) {
            success = this.slaveInstance.stop();
        }
        if (this.masterInstance != null) {
            success = this.masterInstance.stop() && success;
        }
        return success;
    }
}

