/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.network.multiInstance.master;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xyz.nifeather.morph.network.multiInstance.protocol.IInstanceClientHandler;
import xyz.nifeather.morph.shaded.pluginbase.XiaMoJavaPlugin;

public final class InstanceServer
extends WebSocketServer {
    private final Logger logger;
    private final IInstanceClientHandler clientHandler;
    private final List<WebSocket> connectedSockets = new CopyOnWriteArrayList<WebSocket>();
    public boolean running;

    private void logServerInfo(String message) {
        this.logger.info("[S@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logServerWarn(String message) {
        this.logger.warn("[S@%s] %s".formatted(Integer.toHexString(this.hashCode()), message));
    }

    private void logServerError(String message, Throwable t) {
        this.logger.warn("[S@%s] %s".formatted(Integer.toHexString(this.hashCode()), message), t);
    }

    public InstanceServer(XiaMoJavaPlugin plugin, InetSocketAddress address, IInstanceClientHandler iInstanceClientHandler) {
        super(address);
        this.setReuseAddr(true);
        this.logger = plugin.getSLF4JLogger();
        this.clientHandler = iInstanceClientHandler;
        plugin.schedule(this::load);
    }

    private void load() {
    }

    public List<WebSocket> getConnectedSockets() {
        return new ObjectArrayList(this.connectedSockets);
    }

    @Override
    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        this.logServerInfo("New connection opened: " + String.valueOf(webSocket.getRemoteSocketAddress()));
        this.connectedSockets.add(webSocket);
    }

    @Override
    public void stop(int timeout, String closeMessage) throws InterruptedException {
        this.logServerInfo("Stopping instance server...");
        super.stop(timeout, closeMessage);
        this.running = false;
    }

    @Override
    public void onClose(WebSocket webSocket, int i, String s, boolean b) {
        this.logServerInfo("Connection closed: " + String.valueOf(webSocket.getRemoteSocketAddress()));
        this.connectedSockets.remove(webSocket);
        this.clientHandler.onConnectionClose(webSocket);
    }

    @Override
    public void onMessage(WebSocket webSocket, String msg) {
        this.clientHandler.onMessage(new WsRecord(webSocket, msg), this);
    }

    @Override
    public void onError(@Nullable WebSocket webSocket, Exception e) {
        String socketAddress = "<unknown socket @ %s>".formatted(webSocket);
        if (webSocket != null) {
            socketAddress = webSocket.getRemoteSocketAddress().toString();
        }
        this.logServerError("An error occurred with socket '%s'".formatted(socketAddress), e);
    }

    @Override
    public void onStart() {
        this.logServerInfo("Master websocket server started on " + this.getAddress().toString());
        this.clientHandler.onServerStart(this);
        this.running = true;
    }

    public void dispose() {
    }

    public record WsRecord(WebSocket socket, String rawMessage) {
    }
}

