/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.shaded.pluginbase.Configuration;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.shaded.pluginbase.Configuration.ConfigNode;

public class ConfigOption<T> {
    private final ConfigNode node;
    private final T defaultValue;
    private final List<String> flags = new ObjectArrayList();
    private final Class<T> type;

    public Class<T> type() {
        return this.type;
    }

    public ConfigNode node() {
        return this.node;
    }

    @NotNull
    public T getDefault() {
        return this.defaultValue;
    }

    public ConfigOption(ConfigNode node, Class<T> type, T defaultValue) {
        this.node = node;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public ConfigOption<T> withFlag(String flag) {
        if (this.containsFlag(flag)) {
            return this;
        }
        this.flags.add(flag);
        return this;
    }

    public boolean containsFlag(String flag) {
        return this.flags.stream().anyMatch(f -> f.equalsIgnoreCase(flag));
    }

    public String toString() {
        return this.node.toString();
    }

    public ConfigOption<T> setExcludeFromInit() {
        return this.withFlag("exclude_from_init");
    }

    public boolean excludeFromInit() {
        return this.containsFlag("exclude_from_init");
    }

    public static <X> ConfigOptionBuilder<X> builder() {
        return new ConfigOptionBuilder();
    }

    public static <X> ConfigOptionBuilder<X> builder(Class<X> type) {
        return new ConfigOptionBuilder<X>().type(type);
    }

    public static class ConfigOptionBuilder<T> {
        private ConfigNode node;
        private boolean typeAssigned;
        @Nullable
        private Class<T> type;
        private T defaultValue;
        private boolean excludeFromInit;

        public ConfigOptionBuilder<T> node(ConfigNode node) {
            this.node = node;
            return this;
        }

        public ConfigOptionBuilder<T> defaultValue(T defaultValue) {
            if (!this.typeAssigned) {
                this.type = defaultValue.getClass();
            }
            this.defaultValue = defaultValue;
            return this;
        }

        public ConfigOptionBuilder<T> type(Class<T> type) {
            this.typeAssigned = true;
            this.type = type;
            return this;
        }

        public ConfigOptionBuilder<T> excludeFromInit(boolean excludeFromInit) {
            this.excludeFromInit = excludeFromInit;
            return this;
        }

        public ConfigOption<T> build() {
            ConfigOption<T> option = new ConfigOption<T>(this.node, this.type, this.defaultValue);
            if (this.excludeFromInit) {
                option.setExcludeFromInit();
            }
            return option;
        }
    }
}

