/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.storage.playerdata;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.interfaces.IManagePlayerData;
import xyz.nifeather.morph.misc.DisguiseMeta;
import xyz.nifeather.morph.misc.DisguiseTypes;
import xyz.nifeather.morph.storage.DirectoryJsonBasedStorage;
import xyz.nifeather.morph.storage.playerdata.LegacyPlayerDataStore;
import xyz.nifeather.morph.storage.playerdata.PlayerMeta;

public class PlayerDataStoreNew
extends DirectoryJsonBasedStorage<PlayerMeta>
implements IManagePlayerData {
    private static final PlayerMeta defaultMeta = new PlayerMeta();
    private static final int TARGET_PACKAGE_VERSION = 1;
    private final Map<String, DisguiseMeta> cachedMetas = new ConcurrentHashMap<String, DisguiseMeta>();
    private final Map<UUID, PlayerMeta> trackedPlayerMetaMap = new ConcurrentHashMap<UUID, PlayerMeta>();
    private final AtomicBoolean noLazyLoad = new AtomicBoolean(false);

    public PlayerDataStoreNew() {
        super("playerdata");
        int packageVersion = this.getPackageVersion();
        if (packageVersion < 1) {
            this.update(packageVersion);
        }
        PlayerDataStoreNew.defaultMeta.uniqueId = UUID.fromString("0-0-0-0-0");
        PlayerDataStoreNew.defaultMeta.playerName = "~RESERVED META, SHOULD NOT BE USED~";
    }

    private void update(int currentVersion) {
        File legacyDataFile;
        if (currentVersion < 1 && (legacyDataFile = new File(this.plugin.getDataFolder(), "data.json")).exists()) {
            this.migrateFromLegacyStorage();
        }
        this.setPackageVersion(1);
    }

    private void migrateFromLegacyStorage() {
        this.logger.info("Migrating player data...");
        LegacyPlayerDataStore legacyStorage = new LegacyPlayerDataStore();
        legacyStorage.initializeStorage();
        legacyStorage.getAll().forEach(this::save);
        File file = legacyStorage.file();
        boolean success = file.renameTo(new File(file.getParent(), "data.json.old"));
        if (!success) {
            this.logger.info("Can't rename 'data.json' to 'data.json.old', but it's not a big deal, I guess...");
        }
        this.logger.info("Done migrating player data!");
    }

    public void save(PlayerMeta playerMeta) {
        UUID uuid = playerMeta.uniqueId;
        if (uuid == null) {
            this.logger.warn("Found a PlayerMeta that doesn't have an UUID! Ignoring...");
            return;
        }
        String path = this.getPath(playerMeta.uniqueId.toString()) + ".json";
        File file = this.directoryStorage.getFile(path, true);
        if (file == null) {
            this.logger.warn("Cannot save disguise configuration for " + String.valueOf(uuid));
            return;
        }
        String json = this.gson.toJson((Object)playerMeta);
        try {
            FileUtils.writeStringToFile((File)file, (String)json, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable t) {
            this.logger.error("Can't write content to file: " + t.getMessage());
        }
    }

    @Override
    protected PlayerMeta getDefault() {
        return defaultMeta;
    }

    @Override
    @NotNull
    public DisguiseMeta getDisguiseMeta(String rawString) {
        DisguiseMeta cached = this.cachedMetas.getOrDefault(rawString, null);
        if (cached != null) {
            return cached;
        }
        DisguiseTypes type = DisguiseTypes.fromId(rawString);
        DisguiseMeta meta = new DisguiseMeta(rawString, type);
        this.cachedMetas.put(rawString, meta);
        return meta;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.cachedMetas.clear();
    }

    @Override
    public List<DisguiseMeta> getAvailableDisguisesFor(Player player) {
        return this.getPlayerMeta((OfflinePlayer)player).getUnlockedDisguises();
    }

    @Override
    public CompletableFuture<PlayerMeta> loadPlayerDataAsync(UUID uuid) {
        OfflinePlayer offline = Bukkit.getOfflinePlayer((UUID)uuid);
        return CompletableFuture.completedFuture(this.getPlayerMeta(offline));
    }

    @Override
    public boolean grantMorphToPlayer(Player player, String disguiseIdentifier) {
        PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)player);
        DisguiseMeta disguiseMeta = this.getDisguiseMeta(disguiseIdentifier);
        if (disguiseMeta == null) {
            return false;
        }
        if (playerMeta.getUnlockedDisguiseIdentifiers().stream().anyMatch(str -> str.equalsIgnoreCase(disguiseIdentifier))) {
            return false;
        }
        playerMeta.addDisguise(disguiseMeta);
        this.save(playerMeta);
        return true;
    }

    @Override
    public boolean revokeMorphFromPlayer(Player player, String disguiseIdentifier) {
        PlayerMeta playerMeta = this.getPlayerMeta((OfflinePlayer)player);
        DisguiseMeta match = playerMeta.getUnlockedDisguises().stream().filter(meta -> meta.equals(disguiseIdentifier)).findFirst().orElse(null);
        if (match == null) {
            return false;
        }
        playerMeta.removeDisguise(match);
        return true;
    }

    private boolean isDefaultMeta(@Nullable PlayerMeta meta) {
        return meta == null || meta.equals(defaultMeta);
    }

    @Override
    @NotNull
    public PlayerMeta getPlayerMeta(OfflinePlayer player) {
        UUID uuid = player.getUniqueId();
        PlayerMeta tracked = this.trackedPlayerMetaMap.getOrDefault(uuid, null);
        if (tracked != null) {
            return tracked;
        }
        PlayerMeta storedMeta = (PlayerMeta)this.get(uuid.toString());
        if (!this.isDefaultMeta(storedMeta)) {
            storedMeta.playerName = player.getName();
            this.initializePlayerMeta(storedMeta, uuid);
            this.trackedPlayerMetaMap.put(uuid, storedMeta);
            return storedMeta;
        }
        PlayerMeta metaInstance = new PlayerMeta();
        metaInstance.uniqueId = player.getUniqueId();
        metaInstance.playerName = player.getName();
        this.initializePlayerMeta(metaInstance, uuid);
        this.trackedPlayerMetaMap.put(uuid, metaInstance);
        return metaInstance;
    }

    private void initializePlayerMeta(PlayerMeta meta, UUID matchingUUID) {
        meta.uniqueId = matchingUUID;
        if (FeatherMorphMain.getInstance().debugOutputEnabled()) {
            this.logger.info("Doing init for " + String.valueOf(meta));
        }
        ObjectArrayList list = new ObjectArrayList();
        ObjectArrayList unlockedDisguiseIdentifiers = new ObjectArrayList(meta.getUnlockedDisguiseIdentifiers());
        unlockedDisguiseIdentifiers.sort(null);
        unlockedDisguiseIdentifiers.forEach(disguiseId -> {
            DisguiseTypes type = DisguiseTypes.fromId(disguiseId);
            if (type != null) {
                list.add((Object)new DisguiseMeta((String)disguiseId, DisguiseTypes.fromId(disguiseId)));
            } else {
                this.logger.warn("Unknown disguise identifier data '%s' owned by '%s'".formatted(disguiseId, matchingUUID));
            }
        });
        meta.setUnlockedDisguises((ObjectArrayList<DisguiseMeta>)list);
    }

    @Override
    public boolean reload() {
        this.clearCache();
        this.trackedPlayerMetaMap.clear();
        if (this.noLazyLoad.get()) {
            this.loadAll();
        }
        return true;
    }

    @Override
    public boolean save() {
        this.trackedPlayerMetaMap.forEach((uuid, meta) -> this.save((PlayerMeta)meta));
        return true;
    }

    @Override
    public List<PlayerMeta> getRange(List<UUID> list) {
        ObjectArrayList metaList = new ObjectArrayList();
        list.forEach(arg_0 -> this.lambda$getRange$4((List)metaList, arg_0));
        return metaList;
    }

    public void loadAll() {
        this.logger.info("Force loading all player data...");
        File[] files = this.directoryStorage.getFiles();
        int count = 0;
        for (File file : files) {
            PlayerMeta meta;
            if (file.isDirectory()) continue;
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            UUID uuid = null;
            try {
                uuid = UUID.fromString(fileName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (uuid == null || this.trackedPlayerMetaMap.containsKey(uuid) || this.isDefaultMeta(meta = (PlayerMeta)this.get(fileName))) continue;
            this.initializePlayerMeta(meta, uuid);
            this.trackedPlayerMetaMap.put(uuid, meta);
            ++count;
        }
        this.logger.info("Loaded %s player data".formatted(count));
    }

    private /* synthetic */ void lambda$getRange$4(List metaList, UUID uuid) {
        PlayerMeta existing = this.getPlayerMeta(Bukkit.getOfflinePlayer((UUID)uuid));
        metaList.add(existing);
    }

    public static class PackageVersions {
        public static final int INITIAL = 1;
    }
}

