/*
 * Decompiled with CFR 0.152.
 */
package xyz.nifeather.morph.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.nifeather.morph.FeatherMorphMain;
import xyz.nifeather.morph.messages.DumpResult;
import xyz.nifeather.morph.misc.ExecutionErrorException;

public class PluginAssetUtils {
    public static final String assetPath = "assets/feathermorph";
    private static final List<String> allSupportedLanguages = List.of("zh_cn", "en_us", "ru_ru");

    public static byte @Nullable [] getFileBytes(String path) {
        FeatherMorphMain plugin = (FeatherMorphMain)FeatherMorphMain.getPlugin(FeatherMorphMain.class);
        InputStream stream = plugin.getResource(path);
        if (stream == null) {
            return null;
        }
        try {
            return stream.readAllBytes();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Optional<String> getFileStringsOptional(String path) {
        byte[] bytes = PluginAssetUtils.getFileBytes(path);
        if (bytes == null) {
            return Optional.empty();
        }
        return Optional.of(new String(bytes, StandardCharsets.UTF_8));
    }

    public static String getFileStrings(String path) {
        byte[] bytes = PluginAssetUtils.getFileBytes(path);
        if (bytes == null) {
            return "";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String langPath(@NotNull String languageCode) {
        return "assets/feathermorph/lang/" + languageCode + ".json";
    }

    public static List<String> allSupportedLanguages() {
        return allSupportedLanguages;
    }

    public static DumpResult extractLocaleFile(String targetLocale, File parentDirectory, boolean overwriteExistingIfExist) throws ExecutionErrorException {
        String path;
        Optional<String> asset;
        File targetFile = new File(parentDirectory, "%s.json".formatted(targetLocale));
        if (targetFile.exists()) {
            try {
                if (overwriteExistingIfExist) {
                    if (!targetFile.delete()) {
                        throw ExecutionErrorException.forMethod("extractLocaleFile").withMessage("Failed to delete the original file!").create();
                    }
                } else {
                    File fileAsNew = new File(parentDirectory, "%s.fmnew.json".formatted(targetLocale));
                    if (fileAsNew.exists() && !fileAsNew.delete()) {
                        throw ExecutionErrorException.forMethod("extractLocaleFile").withMessage("Failed to delete the original fmnew file!").create();
                    }
                    targetFile = fileAsNew;
                }
            }
            catch (SecurityException e) {
                throw ExecutionErrorException.forMethod("dumpFromAssets").causedBy(e).withMessage("Unknown error occurred while attempting to make backup").create();
            }
        }
        if ((asset = PluginAssetUtils.getFileStringsOptional(path = PluginAssetUtils.langPath(targetLocale))).isEmpty()) {
            throw ExecutionErrorException.forMethod("dumpFromAssets").withMessage("Language file for locale %s doesn't exist in plugin assets".formatted(targetLocale)).create();
        }
        try {
            if (!parentDirectory.exists()) {
                Files.createDirectory(parentDirectory.toPath(), new FileAttribute[0]);
            }
            Files.writeString(targetFile.toPath(), (CharSequence)asset.get(), StandardCharsets.UTF_8, new OpenOption[0]);
            return new DumpResult(targetFile);
        }
        catch (IOException e) {
            throw ExecutionErrorException.forMethod("dumpFromAssets").causedBy(e).withMessage("Unable to write file!").create();
        }
    }
}

