/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.mixin.SimpleInventoryAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InventoryWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/gui/container/generic_54.png");
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_TEXTURE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final int textureWidth = 176;
    private static final int textureHeight = 222;
    private static final int borderWidth = 7;
    private static final int slotHeight = 18;
    private static final int borderWidthTop = 17;
    private static final int splitterHeight = 14;
    private final int columns;
    private final int rows;
    public final NonNullList<Slot> slots = NonNullList.create();
    private final Component title;
    private Slot focusedSlot;
    private ItemStack mouseStack;
    SimpleContainer inventory;

    public InventoryWidget(int x, int y, int columns, int rows, Component title) {
        super(x, y, columns * 18 + 14, rows * 18 + 17 + 7 + 14, CommonComponents.EMPTY);
        this.title = title;
        this.columns = columns;
        this.rows = rows;
        this.inventory = new SimpleContainer(columns * rows);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = new Slot((Container)this.inventory, this.slots.size(), x + 1 + 7 + column * 18, y + 1 + 17 + row * 18 + (row == rows - 1 ? 14 : 0));
                slot.setByPlayer(ItemStack.EMPTY);
                this.slots.add((Object)slot);
            }
        }
        this.inventory.setItem(0, new ItemStack((ItemLike)Items.COBBLESTONE, 32));
        this.mouseStack = ItemStack.EMPTY;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, 7, this.height - 7, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX(), this.getY() + this.height - 7, 0.0f, 215.0f, 7, 7, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + 7, this.getY(), 7.0f, 0.0f, this.width - 14, 17, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + this.width - 7, this.getY(), 169.0f, 0.0f, 7, this.height - 7, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + this.width - 7, this.getY() + this.height - 7, 169.0f, 215.0f, 7, 7, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + 7, this.getY() + this.height - 7, 7.0f, 215.0f, this.width - 14, 7, 256, 256);
        context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + 7, this.getY() + 17 + (this.rows - 1) * 18, 7.0f, 125.0f, this.width - 14, 14, 256, 256);
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                context.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.getX() + 7 + column * 18, this.getY() + 17 + row * 18 + (row == this.rows - 1 ? 14 : 0), 7.0f, 17.0f, 18, 18, 256, 256);
            }
        }
        Font textRenderer = Minecraft.getInstance().font;
        int maxNameWidth = this.width - 14 - 2;
        Component trimmedName = this.title;
        if (textRenderer.width((FormattedText)this.title) > maxNameWidth) {
            trimmedName = FormattedText.composite((FormattedText[])new FormattedText[]{textRenderer.substrByWidth((FormattedText)this.title, maxNameWidth - textRenderer.width((FormattedText)CommonComponents.ELLIPSIS)), CommonComponents.ELLIPSIS});
        }
        context.drawString(textRenderer, trimmedName.getString(), this.getX() + 8, this.getY() + 6, 0x404040, false);
        for (Slot slot : this.slots) {
            if (this.isPointOverSlot(slot, mouseX, mouseY) && slot.isActive()) {
                this.focusedSlot = slot;
                if (this.focusedSlot != null && this.focusedSlot.isHighlightable()) {
                    context.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_TEXTURE, this.focusedSlot.x - 4, this.focusedSlot.y - 4, 24, 24);
                }
            }
            if (!slot.isActive()) continue;
            this.drawSlot(context, slot);
        }
        if (!this.mouseStack.isEmpty()) {
            int x = mouseX - 8;
            int y = mouseY - 8;
            context.renderItem(this.mouseStack, x, y);
            context.renderItemDecorations(Minecraft.getInstance().font, this.mouseStack, x, y);
        }
    }

    private boolean isPointOverSlot(Slot slot, double mouseX, double mouseY) {
        if (slot == null) {
            return false;
        }
        int x = slot.x;
        int y = slot.y;
        return mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18);
    }

    private void drawSlot(GuiGraphics context, Slot slot) {
        ItemStack itemStack = slot.getItem();
        context.renderItem(itemStack, slot.x, slot.y);
        context.renderItemDecorations(Minecraft.getInstance().font, itemStack, slot.x, slot.y);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPointOverSlot(this.focusedSlot, mouseX, mouseY)) {
            if (Screen.hasShiftDown()) {
                if (this.focusedSlot.getContainerSlot() >= this.slots.size() - this.columns) {
                    for (int i = 0; i < this.slots.size() - this.columns; ++i) {
                        if (!this.moveItems(i)) continue;
                        return true;
                    }
                } else {
                    for (int i = this.slots.size() - 1; i >= this.slots.size() - this.columns; --i) {
                        if (!this.moveItems(i)) continue;
                        return true;
                    }
                }
            } else {
                if (this.mouseStack.isEmpty() && !this.focusedSlot.getItem().isEmpty()) {
                    this.mouseStack = this.focusedSlot.getItem().copy();
                    this.focusedSlot.setByPlayer(ItemStack.EMPTY);
                    return true;
                }
                if (!this.mouseStack.isEmpty() && this.focusedSlot.getItem().isEmpty()) {
                    this.focusedSlot.setByPlayer(this.mouseStack.copy());
                    this.mouseStack = ItemStack.EMPTY;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean moveItems(int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.getItem().isEmpty()) {
            SmoothSwapping.currentStacks = ((SimpleInventoryAccessor)this.inventory).getStacks();
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            slot.setByPlayer(this.focusedSlot.getItem());
            this.focusedSlot.setByPlayer(ItemStack.EMPTY);
            SwapUtil.addI2IInventorySwap(slot.getContainerSlot(), this.focusedSlot, slot, false, slot.getItem().getCount());
            return true;
        }
        return false;
    }
}

