/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.Vec2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatmullRomWidget
extends AbstractWidget {
    private List<Vec2> points;
    Integer hoveredPointIndex = null;
    private final int borderSize;
    private final int gridWidth;
    private final int gridHeight;
    private final int verticalLines;
    private final int horizontalLines;
    private double oldMouseX = 0.0;
    private double oldMouseY = 0.0;
    private final Component tooltipText;
    private long hoverStartTime = 0L;

    public CatmullRomWidget(int x, int y, int gridWidth, int gridHeight, int borderSize, int verticalLines, int horizontalLines, List<Vec2> points) {
        super(x, y, gridWidth + 2 * borderSize, gridHeight + 2 * borderSize, TextComponent.f_131282_);
        this.points = points;
        this.borderSize = borderSize;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.verticalLines = verticalLines;
        this.horizontalLines = horizontalLines;
        this.tooltipText = new TranslatableComponent("smoothswapping.config.option.animationspeed.tooltip");
    }

    public void m_7428_(PoseStack matrices, int mouseX, int mouseY) {
        if (this.m_198029_()) {
            if (this.hoverStartTime == 0L) {
                this.hoverStartTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.hoverStartTime >= 1000L) {
                Minecraft client = Minecraft.m_91087_();
                Screen screen = client.f_91080_;
                if (screen == null) {
                    return;
                }
                List lines = client.f_91062_.m_92923_((FormattedText)this.tooltipText, 200);
                if (lines.isEmpty()) {
                    return;
                }
                int tooltipWidth = 0;
                int tooltipHeight = lines.size() == 1 ? -2 : 0;
                for (FormattedCharSequence line : lines) {
                    int k = client.f_91062_.m_92724_(line);
                    if (k > tooltipWidth) {
                        tooltipWidth = k;
                    }
                    tooltipHeight += 10;
                }
                int xOffset = 10;
                int renderX = mouseX + xOffset;
                int renderY = mouseY - tooltipHeight;
                if (renderY + tooltipHeight > screen.f_96544_) {
                    renderY = this.f_93621_ - tooltipHeight - 1;
                }
                if (renderX + tooltipWidth > screen.f_96543_) {
                    renderX = Math.max(this.f_93620_ + this.f_93618_ - tooltipWidth - xOffset, 4);
                }
                screen.m_96617_(matrices, lines, renderX - 12, renderY + 12);
            }
        } else {
            this.hoverStartTime = 0L;
        }
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        int stepSize;
        int i;
        if ((double)mouseX != this.oldMouseX || (double)mouseY != this.oldMouseY) {
            this.oldMouseX = mouseX;
            this.oldMouseY = mouseY;
        }
        Collections.sort(this.points);
        CatmullRomWidget.m_93172_((PoseStack)matrices, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-100663296);
        for (i = 0; i < this.verticalLines; ++i) {
            stepSize = this.gridWidth / this.verticalLines;
            this.m_93222_(matrices, this.f_93620_ + this.borderSize + stepSize + i * stepSize, this.f_93621_ + this.borderSize, this.f_93621_ + this.borderSize + this.gridHeight, 0x10FFFFFF);
        }
        for (i = 0; i < this.horizontalLines; ++i) {
            stepSize = this.gridHeight / this.horizontalLines;
            this.m_93154_(matrices, this.f_93620_ + this.borderSize, this.f_93620_ + this.borderSize + this.gridWidth, this.f_93621_ + this.borderSize + 1 + i * stepSize, 0x10FFFFFF);
        }
        this.m_93222_(matrices, this.f_93620_ + this.borderSize, this.f_93621_ + this.borderSize, this.f_93621_ + this.borderSize + this.gridHeight, -1);
        this.m_93154_(matrices, this.f_93620_ + this.borderSize, this.f_93620_ + this.borderSize + this.gridWidth, this.f_93621_ + this.borderSize + this.gridHeight, -1);
        for (i = 1; i < this.points.size() - 2; ++i) {
            Vec2 p0 = this.points.get(i - 1);
            Vec2 p1 = this.points.get(i);
            Vec2 p2 = this.points.get(i + 1);
            Vec2 p3 = this.points.get(i + 2);
            CatmullRomSpline spline = new CatmullRomSpline(p0, p1, p2, p3);
            for (float t = 0.0f; t < 1.0f; t += 0.005f) {
                Vec2 point = spline.getSegment().getPoint(t);
                int xC = (int)((double)(this.f_93620_ + this.borderSize) + point.v[0] * (double)this.gridWidth) + 1;
                int yC = (int)((double)(this.f_93621_ + this.borderSize + this.gridHeight) + -point.v[1] * (double)this.gridHeight) - 1;
                this.drawPixel(matrices, xC, yC, -65536);
            }
        }
        this.hoveredPointIndex = this.hoveredPointIndex(mouseX, mouseY);
        for (i = 1; i < this.points.size() - 1; ++i) {
            Vec2 point = this.points.get(i);
            int xC = (int)((double)(this.f_93620_ + this.borderSize) + point.v[0] * (double)this.gridWidth) + 1;
            int yC = (int)((double)(this.f_93621_ + this.borderSize + this.gridHeight) + -point.v[1] * (double)this.gridHeight) - 1;
            if (this.hoveredPointIndex != null && this.points.get(this.hoveredPointIndex).equals(point)) {
                CatmullRomWidget.m_93172_((PoseStack)matrices, (int)(xC - 2), (int)(yC - 2), (int)(xC + 2), (int)(yC + 2), (int)-256);
                continue;
            }
            CatmullRomWidget.m_93172_((PoseStack)matrices, (int)(xC - 2), (int)(yC - 2), (int)(xC + 2), (int)(yC + 2), (int)-3602177);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.hoveredPointIndex != null) {
                this.points.remove(this.hoveredPointIndex);
            } else if (this.isMouseInGrid(mouseX, mouseY)) {
                this.points.add(new Vec2(this.getPointX(mouseX), this.getPointY(mouseY)));
            }
        }
        return this.m_5953_(mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.hoveredPointIndex != null) {
            Vec2 hoveredPoint = this.points.get(this.hoveredPointIndex);
            double newX = this.getPointX(mouseX);
            double newY = this.getPointY(mouseY);
            if (this.isMouseInGridYExtended(mouseX, mouseY)) {
                hoveredPoint.v[0] = newX;
            }
            if (this.isMouseInGridYExtended(mouseX, mouseY)) {
                hoveredPoint.v[1] = newY;
            }
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.hoveredPointIndex != null) {
            this.m_7212_(mouseX, mouseY, deltaX, deltaY);
            return true;
        }
        return false;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }

    public List<Vec2> getPoints() {
        return this.points;
    }

    public void reset() {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        points.add(new Vec2(0.0, 0.0));
        points.add(new Vec2(0.0, 0.0));
        points.add(new Vec2(1.0, 1.0));
        points.add(new Vec2(1.0, 1.0));
        this.setPoints(points);
    }

    public static List<CatmullRomSpline> splinesFromPoints(List<Vec2> points) {
        ArrayList<CatmullRomSpline> splines = new ArrayList<CatmullRomSpline>();
        for (int i = 1; i < points.size() - 2; ++i) {
            Vec2 p0 = points.get(i - 1);
            Vec2 p1 = points.get(i);
            Vec2 p2 = points.get(i + 1);
            Vec2 p3 = points.get(i + 2);
            splines.add(new CatmullRomSpline(p0, p1, p2, p3));
        }
        return splines;
    }

    public static double getProgress(double t, List<CatmullRomSpline> segments) {
        CatmullRomSpline currentSegment = CatmullRomWidget.getSegmentForT(t, segments);
        double progress = SwapUtil.map(t, currentSegment.oldX, currentSegment.x, 1.0, 0.0);
        return currentSegment.getSegment().getPoint((double)progress).v[1];
    }

    private static CatmullRomSpline getSegmentForT(double t, @NotNull List<CatmullRomSpline> segments) {
        for (CatmullRomSpline spline : segments) {
            if (!(t >= (double)spline.oldX) || !(t < (double)spline.x)) continue;
            return spline;
        }
        return segments.get(0);
    }

    private double getPointX(double globalX) {
        return ((double)(-this.borderSize) + globalX - (double)this.f_93620_ - 1.0) / (double)this.gridWidth;
    }

    private double getPointY(double globalY) {
        return ((double)this.borderSize - globalY + (double)this.gridHeight + (double)this.f_93621_ - 1.0) / (double)this.gridHeight;
    }

    private void drawPixel(PoseStack matrices, int x, int y, int color) {
        CatmullRomWidget.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + 1), (int)(y + 1), (int)color);
    }

    private boolean isMouseInGrid(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX > (double)this.f_93620_ + (double)this.borderSize + 1.0 && mouseX < (double)(this.f_93620_ + this.borderSize + this.gridWidth - 1) && mouseY > (double)this.f_93621_ + (double)this.borderSize + 1.0 && mouseY < (double)(this.f_93621_ + this.borderSize + this.gridHeight - 1);
    }

    private boolean isMouseInGridYExtended(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX > (double)this.f_93620_ + (double)this.borderSize + 1.0 && mouseX < (double)(this.f_93620_ + this.borderSize + this.gridWidth - 1) && mouseY > (double)this.f_93621_ + 1.0 && mouseY < (double)(this.f_93621_ + this.f_93619_ - 1);
    }

    @Nullable
    private Integer hoveredPointIndex(double mouseX, double mouseY) {
        int pointWidth = 4;
        if (this.m_5953_(mouseX, mouseY)) {
            for (int i = 2; i < this.points.size() - 2; ++i) {
                Vec2 point = this.points.get(i);
                int xC = (int)((double)(this.f_93620_ + this.borderSize) + point.v[0] * (double)this.gridWidth) - 1;
                int yC = (int)((double)(this.f_93621_ + this.borderSize + this.gridHeight) - point.v[1] * (double)this.gridHeight) - pointWidth;
                if (!(mouseX >= (double)xC) || !(mouseX < (double)(xC + pointWidth)) || !(mouseY >= (double)yC) || !(mouseY < (double)(yC + pointWidth))) continue;
                return i;
            }
        }
        return null;
    }

    public void setPoints(List<Vec2> points) {
        this.points = points;
    }

    public static class CatmullRomSpline {
        static float tension = 0.0f;
        static float alpha = 0.0f;
        private final Segment segment;
        float x;
        float oldX;

        public CatmullRomSpline(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3) {
            this.x = (float)p2.v[0];
            this.oldX = (float)p1.v[0];
            double t01 = Math.pow(Vec2.distance(p0, p1), alpha);
            double t12 = Math.pow(Vec2.distance(p1, p2), alpha);
            double t23 = Math.pow(Vec2.distance(p2, p3), alpha);
            Vec2 m1 = Vec2.sum(Vec2.diff(p2, p1), Vec2.diff(Vec2.diff(p1, p0).divideScalar(t01), Vec2.diff(p2, p0).divideScalar(t01 + t12)).multiplyScalar(t12)).multiplyScalar(1.0f - tension);
            Vec2 m2 = Vec2.sum(Vec2.diff(p2, p1), Vec2.diff(Vec2.diff(p3, p2).divideScalar(t23), Vec2.diff(p3, p1).divideScalar(t12 + t23)).multiplyScalar(t12)).multiplyScalar(1.0f - tension);
            this.segment = new Segment(Vec2.sum(Vec2.diff(p1, p2).multiplyScalar(2.0), Vec2.sum(m1, m2)), Vec2.diff(Vec2.diff(Vec2.diff(Vec2.diff(p1, p2).multiplyScalar(-3.0), m1), m1), m2), m1, p1);
        }

        private Segment getSegment() {
            return this.segment;
        }

        private record Segment(Vec2 a, Vec2 b, Vec2 c, Vec2 d) {
            public Vec2 getPoint(double t) {
                return Vec2.sum(this.a.copy().multiplyScalar(t * t * t).copy(), Vec2.sum(this.b.copy().multiplyScalar(t * t).copy(), Vec2.sum(this.c.copy().multiplyScalar(t).copy(), this.d)));
            }
        }
    }
}

