/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapStacks;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.Vec2;
import dev.shwg.smoothswapping.config.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class HandledScreenMixin {
    @Shadow
    @Final
    protected AbstractContainerMenu f_97732_;
    @Shadow
    protected int f_97735_;
    @Shadow
    protected int f_97736_;
    @Unique
    private Screen smooth_Swapping$currentScreen = null;

    @Inject(method={"m_6305_(Lcom/mojang/blaze3d/vertex/PoseStack;IIF)V"}, at={@At(value="HEAD")})
    public void onRender(PoseStack matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        try {
            this.smooth_Swapping$doRender(mouseX, mouseY);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void smooth_Swapping$doRender(double mouseX, double mouseY) {
        if (!ConfigManager.getConfig().getToggleMod()) {
            return;
        }
        AbstractContainerScreen handledScreen = (AbstractContainerScreen)this;
        if (handledScreen instanceof CreativeModeInventoryScreen) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null || client.f_91074_.f_36096_ == null) {
            return;
        }
        SmoothSwapping.currentStacks = client.f_91074_.f_36096_.m_38927_();
        try {
            SmoothSwapping.currentCursorStackLock.lock();
            ItemStack cursorStack = client.f_91074_.f_36096_.m_142621_();
            ItemStack prevStack = SmoothSwapping.currentCursorStack.get();
            if (prevStack == null || prevStack.m_41613_() != cursorStack.m_41613_() || prevStack.m_41720_() != cursorStack.m_41720_()) {
                SmoothSwapping.currentCursorStack.set(cursorStack.m_41777_());
            }
        }
        finally {
            SmoothSwapping.currentCursorStackLock.unlock();
        }
        Screen screen = client.f_91080_;
        if (SmoothSwapping.clickSwap) {
            SmoothSwapping.clickSwap = false;
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            return;
        }
        if (this.smooth_Swapping$currentScreen != screen) {
            SmoothSwapping.swaps.clear();
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            this.smooth_Swapping$currentScreen = screen;
            return;
        }
        Map<Integer, ItemStack> changedStacks = this.smooth_Swapping$getChangedStacks(SmoothSwapping.oldStacks, SmoothSwapping.currentStacks);
        if (!SmoothSwapping.clickSwap) {
            int changedStacksSize = changedStacks.size();
            if (changedStacksSize > 1) {
                ArrayList<SwapStacks> moreStacks = new ArrayList<SwapStacks>();
                ArrayList<SwapStacks> lessStacks = new ArrayList<SwapStacks>();
                int totalAmount = 0;
                for (Map.Entry<Integer, ItemStack> stackEntry : changedStacks.entrySet()) {
                    int slotID = stackEntry.getKey();
                    ItemStack newStack = stackEntry.getValue();
                    ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get(slotID);
                    if (SwapUtil.getCount(newStack) > SwapUtil.getCount(oldStack) && this.f_97732_.m_38853_(slotID).m_150651_((Player)Minecraft.m_91087_().f_91074_)) {
                        moreStacks.add(new SwapStacks(slotID, oldStack, newStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(newStack)));
                        totalAmount += SwapUtil.getCount(newStack) - SwapUtil.getCount(oldStack);
                        continue;
                    }
                    if (SwapUtil.getCount(newStack) >= SwapUtil.getCount(oldStack) || !this.f_97732_.m_38853_(slotID).m_150651_((Player)Minecraft.m_91087_().f_91074_) || SmoothSwapping.clickSwapStack != null) continue;
                    lessStacks.add(new SwapStacks(slotID, oldStack, newStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(newStack)));
                }
                if (SmoothSwapping.clickSwapStack != null) {
                    lessStacks.clear();
                    ItemStack newStack = this.f_97732_.m_38853_(SmoothSwapping.clickSwapStack.intValue()).m_7993_();
                    ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get(SmoothSwapping.clickSwapStack.intValue());
                    lessStacks.add(new SwapStacks(SmoothSwapping.clickSwapStack, oldStack, newStack, totalAmount));
                    SmoothSwapping.clickSwapStack = null;
                }
                if (moreStacks.isEmpty()) {
                    SwapUtil.assignI2CSwaps(lessStacks, new Vec2(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_), this.f_97732_);
                } else {
                    SwapUtil.assignI2ISwaps(moreStacks, lessStacks, this.f_97732_);
                }
            } else if (changedStacksSize == 1) {
                ItemStack currentCursorStack = SmoothSwapping.currentCursorStack.get();
                ItemStack oldCursorStack = SmoothSwapping.oldCursorStack;
                if (currentCursorStack != null && oldCursorStack != null && currentCursorStack.m_41720_() == oldCursorStack.m_41720_() && currentCursorStack.m_41613_() != oldCursorStack.m_41613_()) {
                    changedStacks.entrySet().stream().findFirst().ifPresent(changedStack -> {
                        ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get(((Integer)changedStack.getKey()).intValue());
                        ItemStack currentStack = (ItemStack)SmoothSwapping.currentStacks.get(((Integer)changedStack.getKey()).intValue());
                        int cursorStackCountDiff = currentCursorStack.m_41613_() - SmoothSwapping.oldCursorStack.m_41613_();
                        if (oldStack.m_41720_() == currentStack.m_41720_() && oldStack.m_41613_() - currentStack.m_41613_() == cursorStackCountDiff || currentStack.m_41720_() == Items.f_41852_) {
                            SwapStacks lessStack = new SwapStacks((Integer)changedStack.getKey(), oldStack, currentStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(currentStack));
                            SwapUtil.assignI2CSwaps(List.of(lessStack), new Vec2(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_), this.f_97732_);
                        }
                    });
                }
            }
        }
        if (!this.smooth_Swapping$areStacksEqual(SmoothSwapping.oldStacks, SmoothSwapping.currentStacks)) {
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            SmoothSwapping.oldCursorStack = SmoothSwapping.currentCursorStack.get();
        }
    }

    @Unique
    private Map<Integer, ItemStack> smooth_Swapping$getChangedStacks(NonNullList<ItemStack> oldStacks, NonNullList<ItemStack> newStacks) {
        HashMap<Integer, ItemStack> changedStacks = new HashMap<Integer, ItemStack>();
        for (int slotID = 0; slotID < oldStacks.size(); ++slotID) {
            ItemStack newStack = (ItemStack)newStacks.get(slotID);
            ItemStack oldStack = (ItemStack)oldStacks.get(slotID);
            if (ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changedStacks.put(slotID, newStack.m_41777_());
        }
        return changedStacks;
    }

    @Unique
    private boolean smooth_Swapping$areStacksEqual(NonNullList<ItemStack> oldStacks, NonNullList<ItemStack> newStacks) {
        if (oldStacks == null || newStacks == null || oldStacks.size() != newStacks.size()) {
            return false;
        }
        for (int slotID = 0; slotID < oldStacks.size(); ++slotID) {
            ItemStack newStack = (ItemStack)newStacks.get(slotID);
            ItemStack oldStack = (ItemStack)oldStacks.get(slotID);
            if (ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) continue;
            return false;
        }
        return true;
    }
}

