/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.shwg.smoothswapping.ItemStackAccessor;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.ConfigManager;
import dev.shwg.smoothswapping.config.ConfigScreen;
import dev.shwg.smoothswapping.mixin.Matrix4fAccessor;
import dev.shwg.smoothswapping.swaps.InventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToCursorInventorySwap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Final
    @Unique
    private Minecraft smooth_Swapping$client = Minecraft.m_91087_();
    @Unique
    private static boolean smooth_Swapping$isRendering = false;

    @Shadow
    public abstract void m_115123_(ItemStack var1, int var2, int var3);

    @Shadow
    public abstract void m_115174_(Font var1, ItemStack var2, int var3, int var4, @Nullable String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"m_115127_(Lnet/minecraft/world/item/ItemStack;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onItemDraw(ItemStack stack, int x, int y, BakedModel model, CallbackInfo cbi) {
        if (smooth_Swapping$isRendering) {
            return;
        }
        try {
            smooth_Swapping$isRendering = true;
            if (this.smooth_Swapping$isHotbar() && !(this.smooth_Swapping$client.f_91080_ instanceof ConfigScreen)) {
                return;
            }
            if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
                return;
            }
            this.smooth_Swapping$doSwap(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
        finally {
            smooth_Swapping$isRendering = false;
        }
    }

    @Unique
    private void smooth_Swapping$doSwap(ItemStack stack, int x, int y, CallbackInfo cbi) throws Error {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            boolean renderDestinationSlot = true;
            for (int i = 0; i < swapList.size(); ++i) {
                InventorySwap swap2 = swapList.get(i);
                swap2.setRenderDestinationSlot(swap2.isChecked());
                if (!swap2.renderDestinationSlot()) {
                    renderDestinationSlot = false;
                }
                this.smooth_Swapping$renderSwap(swap2, x, y, swap2.getSwapItem());
                if (!SwapUtil.hasArrived(swap2)) continue;
                SwapUtil.setRenderToTrue(swapList);
                swapList.remove(swap2);
            }
            if (renderDestinationSlot) {
                this.m_115123_(stack.m_41777_(), x, y);
            }
            if (swapList.isEmpty()) {
                SmoothSwapping.swaps.remove(index);
            }
            cbi.cancel();
        } else if (SmoothSwapping.swaps.containsKey(-2)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(-2).stream().filter(swap -> !((ItemToCursorInventorySwap)swap).isArrived()).toList();
            if (!swapList.isEmpty() && SwapUtil.swapListIndexOf(swapList, swap -> ((ItemToCursorInventorySwap)swap).getCopiedStackHash() == stack.hashCode()) == -1) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                AbstractContainerMenu handler = null;
                if (player != null) {
                    handler = player.f_36096_;
                }
                for (InventorySwap inventorySwap : swapList) {
                    ItemToCursorInventorySwap swap3 = (ItemToCursorInventorySwap)inventorySwap;
                    if (!swap3.isStartedRender()) {
                        swap3.setStartedRender(true);
                        continue;
                    }
                    if (swap3.isArrived() || handler == null) continue;
                    NonNullList inventoryStacks = handler.m_38927_();
                    if (swap3.getTargetStackHash() == -1 || handler.m_142621_().hashCode() == swap3.getTargetStackHash()) {
                        if (inventoryStacks.contains((Object)stack)) continue;
                        ItemStack copiedStack = swap3.getSwapItem().m_41777_();
                        swap3.setCopiedStackHash(copiedStack.hashCode());
                        if (swap3.getTargetStackHash() == -1) {
                            swap3.setTargetStackHash(stack.hashCode());
                        }
                        this.smooth_Swapping$renderSwap(swap3, x, y, copiedStack);
                        if (!SwapUtil.hasArrived(swap3)) continue;
                        swap3.setArrived(true);
                        continue;
                    }
                    swap3.setArrived(true);
                }
            }
            if (swapList.stream().allMatch(swap -> ((ItemToCursorInventorySwap)swap).isArrived())) {
                SmoothSwapping.swaps.remove(-2);
            }
        }
    }

    @Unique
    private void smooth_Swapping$renderSwap(InventorySwap swap, int x, int y, ItemStack copiedStack) {
        float lastFrameDuration = this.smooth_Swapping$client.m_91297_();
        Config config = ConfigManager.getConfig();
        double swapX = swap.getX();
        double swapY = swap.getY();
        double angle = swap.getAngle();
        double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
        List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
        double ease = CatmullRomWidget.getProgress(progress, splines);
        double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
        double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
        PoseStack matrices = RenderSystem.m_157191_();
        matrices.m_85836_();
        matrices.m_85837_(renderX, -renderY, 350.0);
        RenderSystem.m_157182_();
        this.m_115123_(copiedStack, x, y);
        double speed = swap.getDistance() / 10.0 * (double)config.getAnimationSpeedFormatted();
        swap.setX(swapX + (double)lastFrameDuration * speed * Math.cos(angle));
        swap.setY(swapY + (double)lastFrameDuration * speed * Math.sin(angle));
        matrices.m_85849_();
        RenderSystem.m_157182_();
    }

    @Inject(method={"m_115174_(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDrawItemInSlot(Font textRenderer, ItemStack stack, int x, int y, String countLabel, CallbackInfo cbi) {
        if (this.smooth_Swapping$isHotbar() && !(this.smooth_Swapping$client.f_91080_ instanceof ConfigScreen)) {
            return;
        }
        if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
            return;
        }
        try {
            this.smooth_Swapping$doOverlayRender(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    @Unique
    private void smooth_Swapping$doOverlayRender(ItemStack stack, int x, int y, CallbackInfo cbi) throws StackOverflowError {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            Config config = ConfigManager.getConfig();
            int stackCount = stack.m_41613_();
            boolean renderToSlot = true;
            for (InventorySwap swap : swapList) {
                if (!ItemStack.m_41758_((ItemStack)stack, (ItemStack)swap.getSwapItem())) {
                    SmoothSwapping.swaps.remove(index);
                    return;
                }
                stackCount -= swap.getAmount();
                if (!swap.renderDestinationSlot()) {
                    renderToSlot = false;
                }
                if (swap.getAmount() <= 1 && !stack.m_150947_()) continue;
                String amount = String.valueOf(swap.getAmount());
                double swapX = swap.getX();
                double swapY = swap.getY();
                double angle = swap.getAngle();
                double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
                List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
                double ease = CatmullRomWidget.getProgress(progress, splines);
                double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
                double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
                PoseStack matrices = RenderSystem.m_157191_();
                matrices.m_85836_();
                matrices.m_85837_(renderX, -renderY, 350.0);
                RenderSystem.m_157182_();
                if (stack.m_150947_()) {
                    this.m_115174_(this.smooth_Swapping$client.f_91062_, stack.m_41777_(), x, y, null);
                } else {
                    this.m_115174_(this.smooth_Swapping$client.f_91062_, stack.m_41777_(), x, y, amount);
                }
                matrices.m_85849_();
                RenderSystem.m_157182_();
            }
            if (renderToSlot && stackCount > 1) {
                this.m_115174_(this.smooth_Swapping$client.f_91062_, stack.m_41777_(), x, y, String.valueOf(stackCount));
            }
            cbi.cancel();
        }
    }

    @Unique
    private boolean smooth_Swapping$isHotbar() {
        Matrix4fAccessor matrix = (Matrix4fAccessor)RenderSystem.m_157191_().m_85850_().m_85861_();
        return matrix.m03() <= 0.0f;
    }
}

