/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.Vec2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class CatmullRomWidget
extends AbstractWidget {
    private List<Vec2> points;
    Integer hoveredPointIndex = null;
    private final int borderSize;
    private final int gridWidth;
    private final int gridHeight;
    private final int verticalLines;
    private final int horizontalLines;
    private double oldMouseX = 0.0;
    private double oldMouseY = 0.0;

    public CatmullRomWidget(int x, int y, int gridWidth, int gridHeight, int borderSize, int verticalLines, int horizontalLines, List<Vec2> points) {
        super(x, y, gridWidth + 2 * borderSize, gridHeight + 2 * borderSize, CommonComponents.EMPTY);
        this.points = points;
        this.borderSize = borderSize;
        this.gridHeight = gridHeight;
        this.gridWidth = gridWidth;
        this.verticalLines = verticalLines;
        this.horizontalLines = horizontalLines;
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)"smoothswapping.config.option.animationspeed.tooltip")));
        this.setTooltipDelay(Duration.ofMillis(1000L));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int stepSize;
        int i;
        if ((double)mouseX != this.oldMouseX || (double)mouseY != this.oldMouseY) {
            this.oldMouseX = mouseX;
            this.oldMouseY = mouseY;
        }
        Collections.sort(this.points);
        context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -100663296);
        for (i = 0; i < this.verticalLines; ++i) {
            stepSize = this.gridWidth / this.verticalLines;
            context.vLine(this.getX() + this.borderSize + stepSize + i * stepSize, this.getY() + this.borderSize, this.getY() + this.borderSize + this.gridHeight, 0x10FFFFFF);
        }
        for (i = 0; i < this.horizontalLines; ++i) {
            stepSize = this.gridHeight / this.horizontalLines;
            context.hLine(this.getX() + this.borderSize, this.getX() + this.borderSize + this.gridWidth, this.getY() + this.borderSize + 1 + i * stepSize, 0x10FFFFFF);
        }
        context.vLine(this.getX() + this.borderSize, this.getY() + this.borderSize, this.getY() + this.borderSize + this.gridHeight, -1);
        context.hLine(this.getX() + this.borderSize, this.getX() + this.borderSize + this.gridWidth, this.getY() + this.borderSize + this.gridHeight, -1);
        for (i = 1; i < this.points.size() - 2; ++i) {
            Vec2 p0 = this.points.get(i - 1);
            Vec2 p1 = this.points.get(i);
            Vec2 p2 = this.points.get(i + 1);
            Vec2 p3 = this.points.get(i + 2);
            CatmullRomSpline spline = new CatmullRomSpline(p0, p1, p2, p3);
            for (float t = 0.0f; t < 1.0f; t += 0.005f) {
                Vec2 point = spline.getSegment().getPoint(t);
                int xC = (int)((double)(this.getX() + this.borderSize) + point.v[0] * (double)this.gridWidth) + 1;
                int yC = (int)((double)(this.getY() + this.borderSize + this.gridHeight) + -point.v[1] * (double)this.gridHeight) - 1;
                this.drawPixel(context, xC, yC, -65536);
            }
        }
        this.hoveredPointIndex = this.hoveredPointIndex(mouseX, mouseY);
        for (i = 1; i < this.points.size() - 1; ++i) {
            Vec2 point = this.points.get(i);
            int xC = (int)((double)(this.getX() + this.borderSize) + point.v[0] * (double)this.gridWidth) + 1;
            int yC = (int)((double)(this.getY() + this.borderSize + this.gridHeight) + -point.v[1] * (double)this.gridHeight) - 1;
            if (this.hoveredPointIndex != null && this.points.get(this.hoveredPointIndex).equals(point)) {
                context.fill(xC - 2, yC - 2, xC + 2, yC + 2, -256);
                continue;
            }
            context.fill(xC - 2, yC - 2, xC + 2, yC + 2, -3602177);
        }
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (click.button() == 1) {
            if (this.hoveredPointIndex != null) {
                this.points.remove(this.hoveredPointIndex);
            } else if (this.isMouseInGrid(click.x(), click.y())) {
                this.points.add(new Vec2(this.getPointX(click.x()), this.getPointY(click.y())));
            }
        }
        return this.isMouseOver(click.x(), click.y());
    }

    protected void onDrag(MouseButtonEvent click, double deltaX, double deltaY) {
        if (this.hoveredPointIndex != null) {
            Vec2 hoveredPoint = this.points.get(this.hoveredPointIndex);
            double newX = this.getPointX(click.x());
            double newY = this.getPointY(click.y());
            if (this.isMouseInGridYExtended(click.x(), click.y())) {
                hoveredPoint.v[0] = newX;
            }
            if (this.isMouseInGridYExtended(click.x(), click.y())) {
                hoveredPoint.v[1] = newY;
            }
        }
    }

    public boolean mouseDragged(MouseButtonEvent click, double deltaX, double deltaY) {
        if (this.hoveredPointIndex != null) {
            this.onDrag(click, deltaX, deltaY);
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    public List<Vec2> getPoints() {
        return this.points;
    }

    public void reset() {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        points.add(new Vec2(0.0, 0.0));
        points.add(new Vec2(0.0, 0.0));
        points.add(new Vec2(1.0, 1.0));
        points.add(new Vec2(1.0, 1.0));
        this.setPoints(points);
    }

    public static List<CatmullRomSpline> splinesFromPoints(List<Vec2> points) {
        ArrayList<CatmullRomSpline> splines = new ArrayList<CatmullRomSpline>();
        for (int i = 1; i < points.size() - 2; ++i) {
            Vec2 p0 = points.get(i - 1);
            Vec2 p1 = points.get(i);
            Vec2 p2 = points.get(i + 1);
            Vec2 p3 = points.get(i + 2);
            splines.add(new CatmullRomSpline(p0, p1, p2, p3));
        }
        return splines;
    }

    public static double getProgress(double t, List<CatmullRomSpline> segments) {
        CatmullRomSpline currentSegment = CatmullRomWidget.getSegmentForT(t, segments);
        double progress = SwapUtil.map(t, currentSegment.oldX, currentSegment.x, 1.0, 0.0);
        return currentSegment.getSegment().getPoint((double)progress).v[1];
    }

    private static CatmullRomSpline getSegmentForT(double t, @NotNull List<CatmullRomSpline> segments) {
        for (CatmullRomSpline spline : segments) {
            if (!(t >= (double)spline.oldX) || !(t < (double)spline.x)) continue;
            return spline;
        }
        return segments.get(0);
    }

    private double getPointX(double globalX) {
        return ((double)(-this.borderSize) + globalX - (double)this.getX() - 1.0) / (double)this.gridWidth;
    }

    private double getPointY(double globalY) {
        return ((double)this.borderSize - globalY + (double)this.gridHeight + (double)this.getY() - 1.0) / (double)this.gridHeight;
    }

    private void drawPixel(GuiGraphics context, int x, int y, int color) {
        context.fill(x, y, x + 1, y + 1, color);
    }

    private boolean isMouseInGrid(double mouseX, double mouseY) {
        return this.visible && mouseX > (double)this.getX() + (double)this.borderSize + 1.0 && mouseX < (double)(this.getX() + this.borderSize + this.gridWidth - 1) && mouseY > (double)this.getY() + (double)this.borderSize + 1.0 && mouseY < (double)(this.getY() + this.borderSize + this.gridHeight - 1);
    }

    private boolean isMouseInGridYExtended(double mouseX, double mouseY) {
        return this.visible && mouseX > (double)this.getX() + (double)this.borderSize + 1.0 && mouseX < (double)(this.getX() + this.borderSize + this.gridWidth - 1) && mouseY > (double)this.getY() + 1.0 && mouseY < (double)(this.getY() + this.height - 1);
    }

    @Nullable
    private Integer hoveredPointIndex(double mouseX, double mouseY) {
        int pointWidth = 4;
        if (this.isMouseOver(mouseX, mouseY)) {
            for (int i = 2; i < this.points.size() - 2; ++i) {
                Vec2 point = this.points.get(i);
                int xC = (int)((double)(this.getX() + this.borderSize) + point.v[0] * (double)this.gridWidth) - 1;
                int yC = (int)((double)(this.getY() + this.borderSize + this.gridHeight) - point.v[1] * (double)this.gridHeight) - pointWidth;
                if (!(mouseX >= (double)xC) || !(mouseX < (double)(xC + pointWidth)) || !(mouseY >= (double)yC) || !(mouseY < (double)(yC + pointWidth))) continue;
                return i;
            }
        }
        return null;
    }

    public void setPoints(List<Vec2> points) {
        this.points = points;
    }

    public static class CatmullRomSpline {
        static float tension = 0.0f;
        static float alpha = 0.0f;
        private final Segment segment;
        float x;
        float oldX;

        public CatmullRomSpline(Vec2 p0, Vec2 p1, Vec2 p2, Vec2 p3) {
            this.x = (float)p2.v[0];
            this.oldX = (float)p1.v[0];
            double t01 = Math.pow(Vec2.distance(p0, p1), alpha);
            double t12 = Math.pow(Vec2.distance(p1, p2), alpha);
            double t23 = Math.pow(Vec2.distance(p2, p3), alpha);
            Vec2 m1 = Vec2.sum(Vec2.diff(p2, p1), Vec2.diff(Vec2.diff(p1, p0).divideScalar(t01), Vec2.diff(p2, p0).divideScalar(t01 + t12)).multiplyScalar(t12)).multiplyScalar(1.0f - tension);
            Vec2 m2 = Vec2.sum(Vec2.diff(p2, p1), Vec2.diff(Vec2.diff(p3, p2).divideScalar(t23), Vec2.diff(p3, p1).divideScalar(t12 + t23)).multiplyScalar(t12)).multiplyScalar(1.0f - tension);
            this.segment = new Segment(Vec2.sum(Vec2.diff(p1, p2).multiplyScalar(2.0), Vec2.sum(m1, m2)), Vec2.diff(Vec2.diff(Vec2.diff(Vec2.diff(p1, p2).multiplyScalar(-3.0), m1), m1), m2), m1, p1);
        }

        private Segment getSegment() {
            return this.segment;
        }

        private record Segment(Vec2 a, Vec2 b, Vec2 c, Vec2 d) {
            public Vec2 getPoint(double t) {
                return Vec2.sum(this.a.copy().multiplyScalar(t * t * t).copy(), Vec2.sum(this.b.copy().multiplyScalar(t * t).copy(), Vec2.sum(this.c.copy().multiplyScalar(t).copy(), this.d)));
            }
        }
    }

    public static class CMRTooltipPosition
    implements ClientTooltipPositioner {
        private final CatmullRomWidget widget;
        private final int xOffset = 10;

        public CMRTooltipPosition(CatmullRomWidget widget) {
            this.widget = widget;
        }

        public Vector2ic positionTooltip(int screenWidth, int screenHeight, int x, int y, int width, int height) {
            Vector2i vector2i = new Vector2i();
            vector2i.x = x + 10;
            vector2i.y = y - height;
            if (vector2i.y + height > screenHeight) {
                vector2i.y = this.widget.getY() - height - 1;
            }
            if (vector2i.x + width > screenWidth) {
                vector2i.x = Math.max(this.widget.getX() + this.widget.getWidth() - width - 10, 4);
            }
            return vector2i;
        }
    }
}

