/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import dev.shwg.smoothswapping.ItemStackAccessor;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.ConfigManager;
import dev.shwg.smoothswapping.config.ConfigScreen;
import dev.shwg.smoothswapping.swaps.InventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToCursorInventorySwap;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_332.class})
public abstract class DrawContextMixin {
    @Final
    @Shadow
    private class_4587 field_44657;
    @Final
    @Shadow
    private class_310 field_44656;

    @Shadow
    public abstract void method_51427(class_1799 var1, int var2, int var3);

    @Shadow
    public abstract void method_51432(class_327 var1, class_1799 var2, int var3, int var4, @Nullable String var5);

    @Inject(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onItemDraw(class_1309 entity, class_1937 world, class_1799 stack, int x, int y, int seed, int z, CallbackInfo cbi) {
        if (this.smooth_Swapping$isHotbar() && !(this.field_44656.field_1755 instanceof ConfigScreen)) {
            return;
        }
        if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
            return;
        }
        try {
            this.smooth_Swapping$doSwap(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    @Unique
    private void smooth_Swapping$doSwap(class_1799 stack, int x, int y, CallbackInfo cbi) throws Error {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            boolean renderDestinationSlot = true;
            for (int i = 0; i < swapList.size(); ++i) {
                InventorySwap swap2 = swapList.get(i);
                swap2.setRenderDestinationSlot(swap2.isChecked());
                if (!swap2.renderDestinationSlot()) {
                    renderDestinationSlot = false;
                }
                this.smooth_Swapping$renderSwap(swap2, x, y, swap2.getSwapItem());
                if (!SwapUtil.hasArrived(swap2)) continue;
                SwapUtil.setRenderToTrue(swapList);
                swapList.remove(swap2);
            }
            if (renderDestinationSlot) {
                this.method_51427(stack.method_7972(), x, y);
            }
            if (swapList.isEmpty()) {
                SmoothSwapping.swaps.remove(index);
            }
            cbi.cancel();
        } else if (SmoothSwapping.swaps.containsKey(-2)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(-2).stream().filter(swap -> !((ItemToCursorInventorySwap)swap).isArrived()).toList();
            if (!swapList.isEmpty() && SwapUtil.swapListIndexOf(swapList, swap -> ((ItemToCursorInventorySwap)swap).getCopiedStackHash() == stack.hashCode()) == -1) {
                class_746 player = class_310.method_1551().field_1724;
                class_1703 handler = null;
                if (player != null) {
                    handler = player.field_7512;
                }
                for (InventorySwap inventorySwap : swapList) {
                    ItemToCursorInventorySwap swap3 = (ItemToCursorInventorySwap)inventorySwap;
                    if (!swap3.isStartedRender()) {
                        swap3.setStartedRender(true);
                        continue;
                    }
                    if (swap3.isArrived() || handler == null) continue;
                    class_2371 inventoryStacks = handler.method_7602();
                    if (swap3.getTargetStackHash() == -1 || handler.method_34255().hashCode() == swap3.getTargetStackHash()) {
                        if (inventoryStacks.contains((Object)stack)) continue;
                        class_1799 copiedStack = swap3.getSwapItem().method_7972();
                        swap3.setCopiedStackHash(copiedStack.hashCode());
                        if (swap3.getTargetStackHash() == -1) {
                            swap3.setTargetStackHash(stack.hashCode());
                        }
                        this.smooth_Swapping$renderSwap(swap3, x, y, copiedStack);
                        if (!SwapUtil.hasArrived(swap3)) continue;
                        swap3.setArrived(true);
                        continue;
                    }
                    swap3.setArrived(true);
                }
            }
            if (swapList.stream().allMatch(swap -> ((ItemToCursorInventorySwap)swap).isArrived())) {
                SmoothSwapping.swaps.remove(-2);
            }
        }
    }

    @Unique
    private void smooth_Swapping$renderSwap(InventorySwap swap, int x, int y, class_1799 copiedStack) {
        float lastFrameDuration = this.field_44656.method_60646().method_60636();
        Config config = ConfigManager.getConfig();
        double swapX = swap.getX();
        double swapY = swap.getY();
        double angle = swap.getAngle();
        double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
        List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
        double ease = CatmullRomWidget.getProgress(progress, splines);
        double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
        double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
        this.field_44657.method_22903();
        this.field_44657.method_22904(renderX, -renderY, 350.0);
        this.method_51427(copiedStack, x, y);
        double speed = swap.getDistance() / 10.0 * (double)config.getAnimationSpeedFormatted();
        swap.setX(swapX + (double)lastFrameDuration * speed * Math.cos(angle));
        swap.setY(swapY + (double)lastFrameDuration * speed * Math.sin(angle));
        this.field_44657.method_22909();
    }

    @Inject(method={"drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDrawItemInSlot(class_327 textRenderer, class_1799 stack, int x, int y, String countOverride, CallbackInfo cbi) {
        if (this.smooth_Swapping$isHotbar() && !(this.field_44656.field_1755 instanceof ConfigScreen)) {
            return;
        }
        if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
            return;
        }
        try {
            this.smooth_Swapping$doOverlayRender(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    @Unique
    private void smooth_Swapping$doOverlayRender(class_1799 stack, int x, int y, CallbackInfo cbi) throws StackOverflowError {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            Config config = ConfigManager.getConfig();
            int stackCount = stack.method_7947();
            boolean renderToSlot = true;
            for (InventorySwap swap : swapList) {
                if (!class_1799.method_7984((class_1799)stack, (class_1799)swap.getSwapItem())) {
                    SmoothSwapping.swaps.remove(index);
                    return;
                }
                stackCount -= swap.getAmount();
                if (!swap.renderDestinationSlot()) {
                    renderToSlot = false;
                }
                if (swap.getAmount() <= 1 && !stack.method_31578()) continue;
                String amount = String.valueOf(swap.getAmount());
                double swapX = swap.getX();
                double swapY = swap.getY();
                double angle = swap.getAngle();
                double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
                List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
                double ease = CatmullRomWidget.getProgress(progress, splines);
                double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
                double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
                this.field_44657.method_22903();
                this.field_44657.method_22904(renderX, -renderY, 350.0);
                if (stack.method_31578()) {
                    this.method_51432(this.field_44656.field_1772, stack.method_7972(), x, y, null);
                } else {
                    this.method_51432(this.field_44656.field_1772, stack.method_7972(), x, y, amount);
                }
                this.field_44657.method_22909();
            }
            if (renderToSlot && stackCount > 1) {
                this.method_51432(this.field_44656.field_1772, stack.method_7972(), x, y, String.valueOf(stackCount));
            }
            cbi.cancel();
        }
    }

    @Unique
    private boolean smooth_Swapping$isHotbar() {
        Vector3f zOffset = new Vector3f();
        this.field_44657.method_23760().method_23761().getColumn(3, zOffset);
        return zOffset.round().x <= 0.0f;
    }
}

