/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import dev.shwg.smoothswapping.Vec2;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import java.util.ArrayList;
import java.util.List;

public class Config {
    private boolean toggleMod = true;
    private int animationSpeed = 100;
    private float[][] curvePoints = new float[0][];

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public float getAnimationSpeedFormatted() {
        return (float)this.animationSpeed / 100.0f;
    }

    public List<CatmullRomWidget.CatmullRomSpline> getSplines() {
        return CatmullRomWidget.splinesFromPoints(this.getCurvePoints());
    }

    public void setCurvePoints(List<Vec2> points) {
        float[][] curvePoints = new float[points.size() - 4][2];
        for (int i = 2; i < points.size() - 2; ++i) {
            Vec2 p = points.get(i);
            curvePoints[i - 2][0] = (float)p.v[0];
            curvePoints[i - 2][1] = (float)p.v[1];
        }
        this.curvePoints = curvePoints;
    }

    public List<Vec2> getCurvePoints() {
        ArrayList<Vec2> points = new ArrayList<Vec2>();
        points.add(new Vec2(0.0, 0.0));
        points.add(new Vec2(0.0, 0.0));
        for (float[] curvePoint : this.curvePoints) {
            points.add(new Vec2(curvePoint[0], curvePoint[1]));
        }
        points.add(new Vec2(1.0, 1.0));
        points.add(new Vec2(1.0, 1.0));
        return points;
    }

    public boolean getToggleMod() {
        return this.toggleMod;
    }

    public void setToggleMod(Boolean value) {
        this.toggleMod = value;
    }
}

