/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.config.ConfigManager;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerboundContainerClickPacket.class})
public class ClickSlotPacketMixin {
    @Shadow
    @Final
    private ClickType clickType;
    @Shadow
    @Final
    private Int2ObjectMap<ItemStack> changedSlots;
    @Shadow
    @Final
    private int slotNum;

    @Inject(method={"<init>(IIIILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/item/ItemStack;Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;)V"}, at={@At(value="TAIL")})
    public void onInit(CallbackInfo cbi) {
        if (!ConfigManager.getConfig().getToggleMod()) {
            return;
        }
        SmoothSwapping.swaps.remove(this.slotNum);
        if ((this.clickType == ClickType.QUICK_MOVE || this.clickType == ClickType.SWAP) && this.changedSlots.size() > 1 && Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
            assert (Minecraft.getInstance().player != null);
            LocalPlayer player = Minecraft.getInstance().player;
            AbstractContainerMenu screenHandler = player.containerMenu;
            if (this.slotNum >= 0 && this.slotNum < screenHandler.slots.size()) {
                Slot mouseHoverSlot = screenHandler.getSlot(this.slotNum);
                if (this.clickType == ClickType.QUICK_MOVE && !mouseHoverSlot.allowModification((Player)player)) {
                    ItemStack newMouseStack = (ItemStack)this.changedSlots.get(this.slotNum);
                    ItemStack oldMouseStack = this.smooth_Swapping$getSafeOldStack(this.slotNum);
                    if (newMouseStack != null && oldMouseStack != null && newMouseStack.getCount() - oldMouseStack.getCount() <= 0) {
                        SmoothSwapping.clickSwapStack = this.slotNum;
                    }
                } else if (this.clickType == ClickType.SWAP) {
                    SmoothSwapping.clickSwap = true;
                    for (Map.Entry stackEntry : this.changedSlots.int2ObjectEntrySet()) {
                        int destinationSlotID = (Integer)stackEntry.getKey();
                        if (destinationSlotID < 0 || destinationSlotID >= screenHandler.slots.size() || destinationSlotID == this.slotNum) continue;
                        Slot destinationSlot = screenHandler.getSlot(destinationSlotID);
                        ItemStack destinationOldStack = this.smooth_Swapping$getSafeOldStack(destinationSlotID);
                        if (!mouseHoverSlot.allowModification((Player)player) && destinationSlot.allowModification((Player)player)) {
                            if (!destinationOldStack.isEmpty()) continue;
                            SwapUtil.addI2IInventorySwap(destinationSlotID, mouseHoverSlot, destinationSlot, false, destinationSlot.getItem().getCount());
                            continue;
                        }
                        if (!mouseHoverSlot.allowModification((Player)player) || !destinationSlot.allowModification((Player)player)) continue;
                        if (destinationSlot.hasItem()) {
                            SwapUtil.addI2IInventorySwap(destinationSlotID, mouseHoverSlot, destinationSlot, false, destinationSlot.getItem().getCount());
                        }
                        if (!mouseHoverSlot.hasItem()) continue;
                        SwapUtil.addI2IInventorySwap(this.slotNum, destinationSlot, mouseHoverSlot, false, mouseHoverSlot.getItem().getCount());
                    }
                }
            }
        }
    }

    @Unique
    private ItemStack smooth_Swapping$getSafeOldStack(int slot) {
        NonNullList oldStacks = SmoothSwapping.oldStacks;
        if (oldStacks == null) {
            SmoothSwapping.oldStacks = oldStacks = NonNullList.create();
        }
        if (slot < 0 || slot >= oldStacks.size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)oldStacks.get(slot);
    }
}

