/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.shwg.smoothswapping.ItemStackAccessor;
import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.config.CatmullRomWidget;
import dev.shwg.smoothswapping.config.Config;
import dev.shwg.smoothswapping.config.ConfigManager;
import dev.shwg.smoothswapping.config.ConfigScreen;
import dev.shwg.smoothswapping.swaps.InventorySwap;
import dev.shwg.smoothswapping.swaps.ItemToCursorInventorySwap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class DrawContextMixin {
    @Final
    @Shadow
    private PoseStack pose;
    @Final
    @Shadow
    private Minecraft minecraft;
    @Unique
    private static boolean smooth_Swapping$isRendering = false;

    @Shadow
    public abstract void renderItem(ItemStack var1, int var2, int var3);

    @Shadow
    public abstract void renderItemDecorations(Font var1, ItemStack var2, int var3, int var4, @Nullable String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onItemDraw(LivingEntity entity, Level world, ItemStack stack, int x, int y, int seed, int z, CallbackInfo cbi) {
        if (smooth_Swapping$isRendering) {
            return;
        }
        try {
            smooth_Swapping$isRendering = true;
            if (this.smooth_Swapping$isHotbar() && !(this.minecraft.screen instanceof ConfigScreen)) {
                return;
            }
            if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
                return;
            }
            this.smooth_Swapping$doSwap(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
        finally {
            smooth_Swapping$isRendering = false;
        }
    }

    @Unique
    private void smooth_Swapping$doSwap(ItemStack stack, int x, int y, CallbackInfo cbi) throws Error {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            boolean renderDestinationSlot = true;
            for (int i = 0; i < swapList.size(); ++i) {
                InventorySwap swap2 = swapList.get(i);
                swap2.setRenderDestinationSlot(swap2.isChecked());
                if (!swap2.renderDestinationSlot()) {
                    renderDestinationSlot = false;
                }
                this.smooth_Swapping$renderSwap(swap2, x, y, swap2.getSwapItem());
                if (!SwapUtil.hasArrived(swap2)) continue;
                SwapUtil.setRenderToTrue(swapList);
                swapList.remove(swap2);
            }
            if (renderDestinationSlot) {
                this.renderItem(stack.copy(), x, y);
            }
            if (swapList.isEmpty()) {
                SmoothSwapping.swaps.remove(index);
            }
            cbi.cancel();
        } else if (SmoothSwapping.swaps.containsKey(-2)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(-2).stream().filter(swap -> !((ItemToCursorInventorySwap)swap).isArrived()).toList();
            if (!swapList.isEmpty() && SwapUtil.swapListIndexOf(swapList, swap -> ((ItemToCursorInventorySwap)swap).getCopiedStackHash() == stack.hashCode()) == -1) {
                LocalPlayer player = Minecraft.getInstance().player;
                AbstractContainerMenu handler = null;
                if (player != null) {
                    handler = player.containerMenu;
                }
                for (InventorySwap inventorySwap : swapList) {
                    ItemToCursorInventorySwap swap3 = (ItemToCursorInventorySwap)inventorySwap;
                    if (!swap3.isStartedRender()) {
                        swap3.setStartedRender(true);
                        continue;
                    }
                    if (swap3.isArrived() || handler == null) continue;
                    NonNullList inventoryStacks = handler.getItems();
                    if (swap3.getTargetStackHash() == -1 || handler.getCarried().hashCode() == swap3.getTargetStackHash()) {
                        if (inventoryStacks.contains((Object)stack)) continue;
                        ItemStack copiedStack = swap3.getSwapItem().copy();
                        swap3.setCopiedStackHash(copiedStack.hashCode());
                        if (swap3.getTargetStackHash() == -1) {
                            swap3.setTargetStackHash(stack.hashCode());
                        }
                        this.smooth_Swapping$renderSwap(swap3, x, y, copiedStack);
                        if (!SwapUtil.hasArrived(swap3)) continue;
                        swap3.setArrived(true);
                        continue;
                    }
                    swap3.setArrived(true);
                }
            }
            if (swapList.stream().allMatch(swap -> ((ItemToCursorInventorySwap)swap).isArrived())) {
                SmoothSwapping.swaps.remove(-2);
            }
        }
    }

    @Unique
    private void smooth_Swapping$renderSwap(InventorySwap swap, int x, int y, ItemStack copiedStack) {
        float lastFrameDuration = this.minecraft.getTimer().getGameTimeDeltaTicks();
        Config config = ConfigManager.getConfig();
        double swapX = swap.getX();
        double swapY = swap.getY();
        double angle = swap.getAngle();
        double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
        List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
        double ease = CatmullRomWidget.getProgress(progress, splines);
        double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
        double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
        this.pose.pushPose();
        this.pose.translate(renderX, -renderY, 350.0);
        this.renderItem(copiedStack, x, y);
        double speed = swap.getDistance() / 10.0 * (double)config.getAnimationSpeedFormatted();
        swap.setX(swapX + (double)lastFrameDuration * speed * Math.cos(angle));
        swap.setY(swapY + (double)lastFrameDuration * speed * Math.sin(angle));
        this.pose.popPose();
    }

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onDrawItemInSlot(Font textRenderer, ItemStack stack, int x, int y, String countOverride, CallbackInfo cbi) {
        if (this.smooth_Swapping$isHotbar() && !(this.minecraft.screen instanceof ConfigScreen)) {
            return;
        }
        if (((ItemStackAccessor)stack).smooth_Swapping$isSwapStack()) {
            return;
        }
        try {
            this.smooth_Swapping$doOverlayRender(stack, x, y, cbi);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    @Unique
    private void smooth_Swapping$doOverlayRender(ItemStack stack, int x, int y, CallbackInfo cbi) throws StackOverflowError {
        int index = SwapUtil.getSlotIndex(stack);
        if (SmoothSwapping.swaps.containsKey(index)) {
            List<InventorySwap> swapList = SmoothSwapping.swaps.get(index);
            Config config = ConfigManager.getConfig();
            int stackCount = stack.getCount();
            boolean renderToSlot = true;
            for (InventorySwap swap : swapList) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)swap.getSwapItem())) {
                    SmoothSwapping.swaps.remove(index);
                    return;
                }
                stackCount -= swap.getAmount();
                if (!swap.renderDestinationSlot()) {
                    renderToSlot = false;
                }
                if (swap.getAmount() <= 1 && !stack.isBarVisible()) continue;
                String amount = String.valueOf(swap.getAmount());
                double swapX = swap.getX();
                double swapY = swap.getY();
                double angle = swap.getAngle();
                double progress = 1.0 - SwapUtil.map(Math.hypot(swapX, swapY), 0.0, swap.getDistance(), 1.0, 0.0);
                List<CatmullRomWidget.CatmullRomSpline> splines = config.getSplines();
                double ease = CatmullRomWidget.getProgress(progress, splines);
                double renderX = -swap.getStartX() - Math.cos(angle) * swap.getDistance() * ease;
                double renderY = swap.getStartY() + Math.sin(angle) * swap.getDistance() * ease;
                this.pose.pushPose();
                this.pose.translate(renderX, -renderY, 350.0);
                if (stack.isBarVisible()) {
                    this.renderItemDecorations(this.minecraft.font, stack.copy(), x, y, null);
                } else {
                    this.renderItemDecorations(this.minecraft.font, stack.copy(), x, y, amount);
                }
                this.pose.popPose();
            }
            if (renderToSlot && stackCount > 1) {
                this.renderItemDecorations(this.minecraft.font, stack.copy(), x, y, String.valueOf(stackCount));
            }
            cbi.cancel();
        }
    }

    @Unique
    private boolean smooth_Swapping$isHotbar() {
        Vector3f zOffset = new Vector3f();
        this.pose.last().pose().getColumn(3, zOffset);
        return zOffset.round().x <= 0.0f;
    }
}

