/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.mixin;

import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapStacks;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.Vec2;
import dev.shwg.smoothswapping.config.ConfigManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractRecipeBookScreen.class})
public abstract class RecipeBookScreenMixin<T extends RecipeBookMenu>
extends AbstractContainerScreen<T> {
    @Unique
    private Screen smooth_Swapping$currentScreen = null;

    public RecipeBookScreenMixin(T handler, Inventory inventory, Component title) {
        super(handler, inventory, title);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    public void onRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        try {
            this.smooth_Swapping$doRender(mouseX, mouseY);
        }
        catch (Exception e) {
            SwapUtil.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private void smooth_Swapping$doRender(double mouseX, double mouseY) {
        if (!ConfigManager.getConfig().getToggleMod()) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        if (client.player == null || client.player.containerMenu == null) {
            return;
        }
        SmoothSwapping.currentStacks = client.player.containerMenu.getItems();
        try {
            SmoothSwapping.currentCursorStackLock.lock();
            ItemStack cursorStack = client.player.containerMenu.getCarried();
            ItemStack prevStack = SmoothSwapping.currentCursorStack.get();
            if (prevStack == null || prevStack.getCount() != cursorStack.getCount() || prevStack.getItem() != cursorStack.getItem()) {
                SmoothSwapping.currentCursorStack.set(cursorStack.copy());
            }
        }
        finally {
            SmoothSwapping.currentCursorStackLock.unlock();
        }
        Screen screen = client.screen;
        if (SmoothSwapping.clickSwap) {
            SmoothSwapping.clickSwap = false;
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            return;
        }
        if (this.smooth_Swapping$currentScreen != screen) {
            SmoothSwapping.swaps.clear();
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            this.smooth_Swapping$currentScreen = screen;
            return;
        }
        Map<Integer, ItemStack> changedStacks = this.smooth_Swapping$getChangedStacks(SmoothSwapping.oldStacks, SmoothSwapping.currentStacks);
        if (!SmoothSwapping.clickSwap) {
            int changedStacksSize = changedStacks.size();
            if (changedStacksSize > 1) {
                ArrayList<SwapStacks> moreStacks = new ArrayList<SwapStacks>();
                ArrayList<SwapStacks> lessStacks = new ArrayList<SwapStacks>();
                int totalAmount = 0;
                for (Map.Entry<Integer, ItemStack> stackEntry : changedStacks.entrySet()) {
                    int slotID = stackEntry.getKey();
                    ItemStack newStack = stackEntry.getValue();
                    ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get(slotID);
                    if (SwapUtil.getCount(newStack) > SwapUtil.getCount(oldStack) && ((RecipeBookMenu)this.menu).getSlot(slotID).allowModification((Player)Minecraft.getInstance().player)) {
                        moreStacks.add(new SwapStacks(slotID, oldStack, newStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(newStack)));
                        totalAmount += SwapUtil.getCount(newStack) - SwapUtil.getCount(oldStack);
                        continue;
                    }
                    if (SwapUtil.getCount(newStack) >= SwapUtil.getCount(oldStack) || !((RecipeBookMenu)this.menu).getSlot(slotID).allowModification((Player)Minecraft.getInstance().player) || SmoothSwapping.clickSwapStack != null) continue;
                    lessStacks.add(new SwapStacks(slotID, oldStack, newStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(newStack)));
                }
                if (SmoothSwapping.clickSwapStack != null) {
                    lessStacks.clear();
                    ItemStack newStack = ((RecipeBookMenu)this.menu).getSlot((int)SmoothSwapping.clickSwapStack.shortValue()).getItem();
                    ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get((int)SmoothSwapping.clickSwapStack.shortValue());
                    lessStacks.add(new SwapStacks(SmoothSwapping.clickSwapStack.shortValue(), oldStack, newStack, totalAmount));
                    SmoothSwapping.clickSwapStack = null;
                }
                if (moreStacks.isEmpty()) {
                    SwapUtil.assignI2CSwaps(lessStacks, new Vec2(mouseX - (double)this.leftPos, mouseY - (double)this.topPos), this.menu);
                } else {
                    SwapUtil.assignI2ISwaps(moreStacks, lessStacks, this.menu);
                }
            } else if (changedStacksSize == 1) {
                ItemStack currentCursorStack = SmoothSwapping.currentCursorStack.get();
                ItemStack oldCursorStack = SmoothSwapping.oldCursorStack;
                if (currentCursorStack != null && oldCursorStack != null && currentCursorStack.getItem() == oldCursorStack.getItem() && currentCursorStack.getCount() != oldCursorStack.getCount()) {
                    changedStacks.entrySet().stream().findFirst().ifPresent(changedStack -> {
                        ItemStack oldStack = (ItemStack)SmoothSwapping.oldStacks.get(((Integer)changedStack.getKey()).intValue());
                        ItemStack currentStack = (ItemStack)SmoothSwapping.currentStacks.get(((Integer)changedStack.getKey()).intValue());
                        int cursorStackCountDiff = currentCursorStack.getCount() - SmoothSwapping.oldCursorStack.getCount();
                        if (oldStack.getItem() == currentStack.getItem() && oldStack.getCount() - currentStack.getCount() == cursorStackCountDiff || currentStack.getItem() == Items.AIR) {
                            SwapStacks lessStack = new SwapStacks((Integer)changedStack.getKey(), oldStack, currentStack, SwapUtil.getCount(oldStack) - SwapUtil.getCount(currentStack));
                            SwapUtil.assignI2CSwaps(List.of(lessStack), new Vec2(mouseX - (double)this.leftPos, mouseY - (double)this.topPos), this.menu);
                        }
                    });
                }
            }
        }
        if (!this.smooth_Swapping$areStacksEqual(SmoothSwapping.oldStacks, SmoothSwapping.currentStacks)) {
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            SmoothSwapping.oldCursorStack = SmoothSwapping.currentCursorStack.get();
        }
    }

    @Unique
    private Map<Integer, ItemStack> smooth_Swapping$getChangedStacks(NonNullList<ItemStack> oldStacks, NonNullList<ItemStack> newStacks) {
        HashMap<Integer, ItemStack> changedStacks = new HashMap<Integer, ItemStack>();
        for (int slotID = 0; slotID < oldStacks.size(); ++slotID) {
            ItemStack newStack = (ItemStack)newStacks.get(slotID);
            ItemStack oldStack = (ItemStack)oldStacks.get(slotID);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) continue;
            changedStacks.put(slotID, newStack.copy());
        }
        return changedStacks;
    }

    @Unique
    private boolean smooth_Swapping$areStacksEqual(NonNullList<ItemStack> oldStacks, NonNullList<ItemStack> newStacks) {
        if (oldStacks == null || newStacks == null || oldStacks.size() != newStacks.size()) {
            return false;
        }
        for (int slotID = 0; slotID < oldStacks.size(); ++slotID) {
            ItemStack newStack = (ItemStack)newStacks.get(slotID);
            ItemStack oldStack = (ItemStack)oldStacks.get(slotID);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack)) continue;
            return false;
        }
        return true;
    }
}

