/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.platform.fabric.scheduler;

import ac.grim.grimac.api.plugin.GrimPlugin;
import ac.grim.grimac.platform.api.scheduler.AsyncScheduler;
import ac.grim.grimac.platform.api.scheduler.PlatformScheduler;
import ac.grim.grimac.platform.api.scheduler.TaskHandle;
import ac.grim.grimac.platform.fabric.scheduler.FabricTaskHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class FabricAsyncScheduler
implements AsyncScheduler {
    private final Map<Thread, InternalAsyncTask> asyncTasks = new HashMap<Thread, InternalAsyncTask>();
    private final GrimPlugin plugin;

    public FabricAsyncScheduler(GrimPlugin plugin) {
        this.plugin = plugin;
    }

    public TaskHandle runNow(@NotNull GrimPlugin plugin, @NotNull Runnable task) {
        Thread thread = new Thread(task);
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, new InternalAsyncTask(plugin, cancellationTask));
        thread.start();
        return new FabricTaskHandle(cancellationTask, false);
    }

    public TaskHandle runDelayed(@NotNull GrimPlugin plugin, @NotNull Runnable task, long delay, @NotNull TimeUnit timeUnit) {
        long delayMillis = timeUnit.toMillis(delay);
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(delayMillis);
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, new InternalAsyncTask(plugin, cancellationTask));
        thread.start();
        return new FabricTaskHandle(cancellationTask, false);
    }

    public TaskHandle runAtFixedRate(@NotNull GrimPlugin plugin, @NotNull Runnable task, long delay, long period, @NotNull TimeUnit timeUnit) {
        long delayMillis = timeUnit.toMillis(delay);
        long periodMillis = timeUnit.toMillis(period);
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(delayMillis);
                while (!Thread.currentThread().isInterrupted()) {
                    task.run();
                    Thread.sleep(periodMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Runnable cancellationTask = () -> {
            thread.interrupt();
            this.asyncTasks.remove(thread);
        };
        this.asyncTasks.put(thread, new InternalAsyncTask(plugin, cancellationTask));
        thread.start();
        return new FabricTaskHandle(cancellationTask, false);
    }

    public TaskHandle runAtFixedRate(@NotNull GrimPlugin plugin, @NotNull Runnable task, long initialDelayTicks, long periodTicks) {
        return this.runAtFixedRate(plugin, task, PlatformScheduler.convertTicksToTime((long)initialDelayTicks, (TimeUnit)TimeUnit.MILLISECONDS), PlatformScheduler.convertTicksToTime((long)periodTicks, (TimeUnit)TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public void cancel(@NotNull GrimPlugin plugin) {
        Iterator<Map.Entry<Thread, InternalAsyncTask>> iterator = this.asyncTasks.entrySet().iterator();
        ArrayList<Runnable> cancellationTasks = new ArrayList<Runnable>();
        while (iterator.hasNext()) {
            Map.Entry<Thread, InternalAsyncTask> entry = iterator.next();
            if (!entry.getValue().plugin().equals((Object)plugin)) continue;
            cancellationTasks.add(entry.getValue().runnable());
            iterator.remove();
        }
        for (Runnable cancellationTask : cancellationTasks) {
            cancellationTask.run();
        }
    }

    public void cancelAll() {
        List<Runnable> cancellationTasks = this.asyncTasks.values().stream().map(InternalAsyncTask::runnable).toList();
        this.asyncTasks.clear();
        for (Runnable cancellationTask : cancellationTasks) {
            cancellationTask.run();
        }
    }

    record InternalAsyncTask(GrimPlugin plugin, Runnable runnable) {
    }
}

