/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.combat;

import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.debug.HitboxDebugHandler;
import ac.grim.grimac.checks.impl.combat.EntityPierce;
import ac.grim.grimac.checks.impl.combat.Hitboxes;
import ac.grim.grimac.checks.impl.combat.WallHit;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import ac.grim.grimac.shaded.fastutil.ints.Int2ObjectMap;
import ac.grim.grimac.shaded.fastutil.ints.Int2ObjectOpenHashMap;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.NoCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockHitData;
import ac.grim.grimac.utils.data.EntityHitData;
import ac.grim.grimac.utils.data.HitData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntitySizeable;
import ac.grim.grimac.utils.data.packetentity.dragon.PacketEntityEnderDragonPart;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import ac.grim.grimac.utils.nmsutil.WorldRayTrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CheckData(name="Reach", setback=10.0)
public class Reach
extends Check
implements PacketCheck {
    private static final List<EntityType> blacklisted = Arrays.asList(EntityTypes.BOAT, EntityTypes.CHEST_BOAT, EntityTypes.SHULKER);
    private static final CheckResult NONE = new CheckResult(ResultType.NONE, "");
    private final Int2ObjectMap<Vector3d> playerAttackQueue = new Int2ObjectOpenHashMap<Vector3d>();
    private final Set<Vector3i> blocksChangedThisTick = new HashSet<Vector3i>();
    public static final double extraSearchDistance = 3.0;
    private boolean ignoreNonPlayerTargets;
    private boolean cancelImpossibleHits;
    public double threshold;
    private double cancelBuffer;

    public Reach(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (!this.player.disableGrim && event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
            boolean tooManyAttacks;
            WrapperPlayClientInteractEntity action = new WrapperPlayClientInteractEntity(event);
            if (this.player.getSetbackTeleportUtil().shouldBlockMovement()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
                return;
            }
            PacketEntity entity = this.player.compensatedEntities.entityMap.get(action.getEntityId());
            if (entity == null || entity instanceof PacketEntityEnderDragonPart) {
                if (this.shouldModifyPackets() && this.player.compensatedEntities.serverPositionsMap.containsKey(action.getEntityId())) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                }
                return;
            }
            if (this.ignoreNonPlayerTargets && !entity.type.equals(EntityTypes.PLAYER)) {
                return;
            }
            if (entity.isDead) {
                return;
            }
            if (entity.type == EntityTypes.ARMOR_STAND && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8)) {
                return;
            }
            if (this.player.gamemode == GameMode.CREATIVE || this.player.gamemode == GameMode.SPECTATOR) {
                return;
            }
            if (this.player.inVehicle()) {
                return;
            }
            if (entity.riding != null) {
                return;
            }
            boolean bl = tooManyAttacks = this.playerAttackQueue.size() > 10;
            if (!tooManyAttacks) {
                this.playerAttackQueue.put(action.getEntityId(), new Vector3d(this.player.x, this.player.y, this.player.z));
            }
            boolean knownInvalid = this.isKnownInvalid(entity);
            if (this.shouldModifyPackets() && this.cancelImpossibleHits && knownInvalid || tooManyAttacks) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
        }
        boolean isFlying = WrapperPlayClientPlayerFlying.isFlying(event.getPacketType());
        if (this.isUpdate(event.getPacketType())) {
            this.tickBetterReachCheckWithAngle(isFlying);
        }
    }

    private boolean isKnownInvalid(PacketEntity reachEntity) {
        if ((blacklisted.contains(reachEntity.type) || !reachEntity.isLivingEntity) && reachEntity.type != EntityTypes.END_CRYSTAL) {
            return false;
        }
        if (this.player.gamemode == GameMode.CREATIVE || this.player.gamemode == GameMode.SPECTATOR) {
            return false;
        }
        if (this.player.inVehicle()) {
            return false;
        }
        if (this.cancelBuffer != 0.0) {
            CheckResult result = this.checkReach(reachEntity, new Vector3d(this.player.x, this.player.y, this.player.z), true);
            return result.isFlag();
        }
        SimpleCollisionBox targetBox = reachEntity.getPossibleCollisionBoxes();
        if (reachEntity.type == EntityTypes.END_CRYSTAL) {
            targetBox = new SimpleCollisionBox(reachEntity.trackedServerPosition.getPos().subtract(1.0, 0.0, 1.0), reachEntity.trackedServerPosition.getPos().add(1.0, 2.0, 1.0));
        }
        return ReachUtils.getMinReachToBox(this.player, targetBox) > this.player.compensatedEntities.self.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
    }

    private void tickBetterReachCheckWithAngle(boolean isFlying) {
        for (Int2ObjectMap.Entry entry : this.playerAttackQueue.int2ObjectEntrySet()) {
            PacketEntity reachEntity = this.player.compensatedEntities.entityMap.get(entry.getIntKey());
            if (reachEntity == null) continue;
            CheckResult result = this.checkReach(reachEntity, (Vector3d)entry.getValue(), false);
            switch (result.type().ordinal()) {
                case 0: {
                    PacketEntitySizeable sizeable;
                    Object added = ", type=" + reachEntity.type.getName().getKey();
                    if (reachEntity instanceof PacketEntitySizeable) {
                        sizeable = (PacketEntitySizeable)reachEntity;
                        added = (String)added + ", size=" + sizeable.size;
                    }
                    this.flagAndAlert(result.verbose() + (String)added);
                    break;
                }
                case 1: {
                    PacketEntitySizeable sizeable;
                    Object added = "type=" + reachEntity.type.getName().getKey();
                    if (reachEntity instanceof PacketEntitySizeable) {
                        sizeable = (PacketEntitySizeable)reachEntity;
                        added = (String)added + ", size=" + sizeable.size;
                    }
                    this.player.checkManager.getCheck(Hitboxes.class).flagAndAlert(result.verbose() + (String)added);
                    break;
                }
                case 2: {
                    Object added = reachEntity.type == EntityTypes.PLAYER ? "" : "type=" + reachEntity.type.getName().getKey();
                    this.player.checkManager.getCheck(WallHit.class).flagAndAlert(result.verbose() + (String)added);
                    break;
                }
                case 3: {
                    Object added = reachEntity.type == EntityTypes.PLAYER ? "" : "type=" + reachEntity.type.getName().getKey();
                    this.player.checkManager.getCheck(EntityPierce.class).flagAndAlert(result.verbose() + (String)added);
                }
            }
        }
        this.playerAttackQueue.clear();
        if (isFlying) {
            this.blocksChangedThisTick.clear();
        }
    }

    @NotNull
    private CheckResult checkReach(PacketEntity reachEntity, Vector3d from, boolean isPrediction) {
        SimpleCollisionBox targetBox = reachEntity.getPossibleCollisionBoxes();
        if (reachEntity.type == EntityTypes.END_CRYSTAL) {
            targetBox = new SimpleCollisionBox(reachEntity.trackedServerPosition.getPos().subtract(1.0, 0.0, 1.0), reachEntity.trackedServerPosition.getPos().add(1.0, 2.0, 1.0));
        }
        if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            targetBox.expand(0.1f);
        }
        targetBox.expand(this.threshold);
        if (!this.player.packetStateData.didLastLastMovementIncludePosition || this.player.canSkipTicks()) {
            targetBox.expand(this.player.getMovementThreshold());
        }
        double minDistance = Double.MAX_VALUE;
        ArrayList<Pair<Vector3dm, Double>> lookVecsAndEyeHeights = new ArrayList<Pair<Vector3dm, Double>>();
        double maxReach = this.player.compensatedEntities.self.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        double distance = maxReach + 3.0;
        double[] possibleEyeHeights = this.player.getPossibleEyeHeights();
        Vector3dm[] possibleLookDirs = this.player.getPossibleLookVectors(isPrediction);
        Vector3dm eyePos = new Vector3dm(from.getX(), 0.0, from.getZ());
        block0: for (Vector3dm lookVec : possibleLookDirs) {
            for (double eye : possibleEyeHeights) {
                eyePos.setY(from.getY() + eye);
                Vector3dm endReachPos = eyePos.clone().add(lookVec.getX() * distance, lookVec.getY() * distance, lookVec.getZ() * distance);
                Vector3dm intercept = ReachUtils.calculateIntercept(targetBox, eyePos, endReachPos).first();
                if (ReachUtils.isVecInside(targetBox, eyePos)) {
                    minDistance = 0.0;
                    continue block0;
                }
                if (intercept == null) continue;
                minDistance = Math.min(eyePos.distance(intercept), minDistance);
                lookVecsAndEyeHeights.add(new Pair<Vector3dm, Double>(lookVec, eye));
            }
        }
        if (this.hitboxDebuggingEnabled()) {
            this.sendHitboxDebugData(reachEntity, from, lookVecsAndEyeHeights, isPrediction);
        }
        HitData foundHitData = null;
        if (minDistance <= distance - 3.0 && !this.player.compensatedWorld.isNearHardEntity(this.player.boundingBox.copy().expand(4.0))) {
            @Nullable Pair<Double, HitData> hitResult = WorldRayTrace.didRayTraceHit(this.player, reachEntity, lookVecsAndEyeHeights, from);
            HitData hitData = hitResult.second();
            if (hitData instanceof EntityHitData && this.player.compensatedEntities.getPacketEntityID(((EntityHitData)hitData).getEntity()) != this.player.compensatedEntities.getPacketEntityID(reachEntity)) {
                minDistance = Double.MIN_VALUE;
                foundHitData = hitData;
            } else if (hitData instanceof BlockHitData && !this.blocksChangedThisTick.contains(((BlockHitData)hitData).position())) {
                minDistance = Double.MIN_VALUE;
                foundHitData = hitData;
            }
        }
        if (!blacklisted.contains(reachEntity.type) && reachEntity.isLivingEntity || reachEntity.type == EntityTypes.END_CRYSTAL) {
            if (minDistance == Double.MIN_VALUE && foundHitData != null) {
                this.cancelBuffer = 1.0;
                if (foundHitData instanceof BlockHitData) {
                    return new CheckResult(ResultType.WALL_HIT, "Hit block=" + ((BlockHitData)foundHitData).state().getType().getName() + " ");
                }
                return new CheckResult(ResultType.ENTITY_PIERCE, "Hit entity=" + String.valueOf(((EntityHitData)foundHitData).getEntity().type.getName()) + " ");
            }
            if (minDistance == Double.MAX_VALUE) {
                this.cancelBuffer = 1.0;
                return new CheckResult(ResultType.HITBOX, "");
            }
            if (minDistance > maxReach) {
                this.cancelBuffer = 1.0;
                return new CheckResult(ResultType.REACH, String.format("%.5f", minDistance) + " blocks");
            }
            this.cancelBuffer = Math.max(0.0, this.cancelBuffer - 0.25);
        }
        return NONE;
    }

    @Override
    public void onReload(ConfigManager config) {
        this.ignoreNonPlayerTargets = config.getBooleanElse("Reach.ignore-non-player-targets", false);
        this.cancelImpossibleHits = config.getBooleanElse("Reach.block-impossible-hits", true);
        this.threshold = config.getDoubleElse("Reach.threshold", 5.0E-4);
    }

    public void handleBlockChange(Vector3i vector3i, WrappedBlockState state) {
        if (this.blocksChangedThisTick.size() >= 40) {
            return;
        }
        Vector3dm vector3dm = new Vector3dm(vector3i.x, vector3i.y, vector3i.z);
        Vector3dm vector3dm2 = new Vector3dm(this.player.x, this.player.y, this.player.z);
        if (vector3dm.distanceSquared(vector3dm2) > 6.0) {
            return;
        }
        if (state.equals(this.player.compensatedWorld.getBlock(vector3i))) {
            return;
        }
        this.blocksChangedThisTick.add(vector3i);
    }

    private boolean hitboxDebuggingEnabled() {
        return this.player.checkManager.getCheck(HitboxDebugHandler.class).isEnabled();
    }

    private void sendHitboxDebugData(PacketEntity reachEntity, Vector3d from, List<Pair<Vector3dm, Double>> lookVecsAndEyeHeights, boolean isPrediction) {
        HashMap<Integer, CollisionBox> hitboxes = new HashMap<Integer, CollisionBox>();
        for (Int2ObjectMap.Entry entry : this.player.compensatedEntities.entityMap.int2ObjectEntrySet()) {
            CollisionBox box;
            PacketEntity entity = (PacketEntity)entry.getValue();
            if (!entity.canHit()) continue;
            if (entity.equals(reachEntity)) {
                sBox = box = entity.getPossibleCollisionBoxes();
                ((SimpleCollisionBox)sBox).expand(this.threshold);
                if (!this.player.packetStateData.didLastLastMovementIncludePosition || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                    ((SimpleCollisionBox)sBox).expand(this.player.getMovementThreshold());
                }
            } else {
                box = entity.getMinimumPossibleCollisionBoxes();
                if (box instanceof NoCollisionBox) {
                    hitboxes.put(entry.getIntKey(), NoCollisionBox.INSTANCE);
                    continue;
                }
                if (box instanceof SimpleCollisionBox) {
                    sBox = (SimpleCollisionBox)box;
                    ((SimpleCollisionBox)sBox).expand(-this.threshold);
                    if (!this.player.packetStateData.didLastLastMovementIncludePosition || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                        ((SimpleCollisionBox)sBox).expand(-this.player.getMovementThreshold());
                    }
                }
            }
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9) && box instanceof SimpleCollisionBox) {
                ((SimpleCollisionBox)box).expand(0.1f);
            }
            hitboxes.put(entry.getIntKey(), box);
        }
        this.player.checkManager.getCheck(HitboxDebugHandler.class).sendHitboxData(hitboxes, Collections.singleton(this.player.compensatedEntities.getPacketEntityID(reachEntity)), lookVecsAndEyeHeights, new Vector3dm(from.getX(), from.getY(), from.getZ()), isPrediction, this.player.compensatedEntities.self.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
    }

    private record CheckResult(ResultType type, String verbose) {
        public boolean isFlag() {
            return this.type != ResultType.NONE;
        }
    }

    private static enum ResultType {
        REACH,
        HITBOX,
        WALL_HIT,
        ENTITY_PIERCE,
        NONE;

    }
}

