/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.latency;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import ac.grim.grimac.utils.common.arguments.CommonGrimArguments;
import ac.grim.grimac.utils.latency.ILatencyUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;

public class LatencyUtils
implements ILatencyUtils {
    private final ArrayDeque<TransactionTask> transactionMap = new ArrayDeque();
    private final GrimPlayer player;
    private final ArrayList<Runnable> tasksToRun = new ArrayList();

    public LatencyUtils(GrimPlayer player) {
        this.player = player;
    }

    @Override
    public void addRealTimeTask(int transaction, Runnable runnable) {
        this.addRealTimeTaskInternal(transaction, false, runnable);
    }

    @Override
    public void addRealTimeTaskAsync(int transaction, Runnable runnable) {
        this.addRealTimeTaskInternal(transaction, true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRealTimeTaskInternal(int transactionId, boolean async, Runnable runnable) {
        if (this.player.lastTransactionReceived.get() >= transactionId) {
            if (async) {
                this.player.runSafely(runnable);
            } else {
                runnable.run();
            }
            return;
        }
        ArrayDeque<TransactionTask> arrayDeque = this.transactionMap;
        synchronized (arrayDeque) {
            this.transactionMap.add(new TransactionTask(transactionId, runnable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNettySyncTransaction(int receivedTransactionId) {
        ArrayDeque<TransactionTask> arrayDeque = this.transactionMap;
        synchronized (arrayDeque) {
            TransactionTask taskEntry;
            int taskTransactionId;
            this.tasksToRun.clear();
            Iterator<TransactionTask> iterator = this.transactionMap.iterator();
            while (iterator.hasNext() && receivedTransactionId + 1 >= (taskTransactionId = (taskEntry = iterator.next()).transactionId())) {
                if (receivedTransactionId == taskTransactionId - 1) continue;
                this.tasksToRun.add(taskEntry.task());
                iterator.remove();
            }
            for (Runnable runnable : this.tasksToRun) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    this.handleRunnableError(e);
                }
            }
        }
    }

    private void handleRunnableError(Exception e) {
        LogUtil.error("An error has occurred when running transactions for player: " + this.player.user.getName(), e);
        if (CommonGrimArguments.KICK_ON_TRANSACTION_ERRORS.value().booleanValue()) {
            this.player.disconnect(MessageUtil.miniMessage(MessageUtil.replacePlaceholders(this.player, GrimAPI.INSTANCE.getConfigManager().getDisconnectPacketError())));
        }
    }

    private record TransactionTask(int transactionId, Runnable task) {
    }
}

