/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.utils.nmsutil;

import ac.grim.grimac.checks.impl.combat.Reach;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.utils.collisions.CollisionData;
import ac.grim.grimac.utils.collisions.HitboxData;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.NoCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockHitData;
import ac.grim.grimac.utils.data.EntityHitData;
import ac.grim.grimac.utils.data.HitData;
import ac.grim.grimac.utils.data.Pair;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.math.Vector3dm;
import ac.grim.grimac.utils.nmsutil.Ray;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import lombok.Generated;

public final class WorldRayTrace {
    public static BlockHitData getNearestBlockHitResult(GrimPlayer player, StateType heldItem, boolean sourcesHaveHitbox, boolean fluidPlacement, boolean itemUsePlacement) {
        Vector3d startingPos = new Vector3d(player.x, player.y + player.getEyeHeight(), player.z);
        Vector3dm startingVec = new Vector3dm(startingPos.getX(), startingPos.getY(), startingPos.getZ());
        Ray trace = new Ray(player, startingPos.getX(), startingPos.getY(), startingPos.getZ(), player.yaw, player.pitch);
        double distance = itemUsePlacement && player.getClientVersion().isOlderThan(ClientVersion.V_1_20_5) ? 5.0 : player.compensatedEntities.self.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vector3dm endVec = trace.getPointAtDistance(distance);
        Vector3d endPos = new Vector3d(endVec.getX(), endVec.getY(), endVec.getZ());
        return WorldRayTrace.traverseBlocks(player, startingPos, endPos, (block, vector3i) -> {
            if (fluidPlacement && player.getClientVersion().isOlderThan(ClientVersion.V_1_13) && CollisionData.getData(block.getType()).getMovementCollisionBox(player, player.getClientVersion(), (WrappedBlockState)block, vector3i.getX(), vector3i.getY(), vector3i.getZ()).isNull()) {
                return null;
            }
            CollisionBox data = HitboxData.getBlockHitbox(player, heldItem, player.getClientVersion(), block, false, vector3i.getX(), vector3i.getY(), vector3i.getZ());
            ArrayList<SimpleCollisionBox> boxes = new ArrayList<SimpleCollisionBox>();
            data.downCast(boxes);
            double bestHitResult = Double.MAX_VALUE;
            Vector3dm bestHitLoc = null;
            BlockFace bestFace = null;
            for (SimpleCollisionBox box : boxes) {
                Vector3dm hitLoc;
                Pair<Vector3dm, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(distance));
                if (intercept.first() == null || !((hitLoc = intercept.first()).distanceSquared(startingVec) < bestHitResult)) continue;
                bestHitResult = hitLoc.distanceSquared(startingVec);
                bestHitLoc = hitLoc;
                bestFace = intercept.second();
            }
            if (bestHitLoc != null) {
                return new BlockHitData((Vector3i)vector3i, bestHitLoc, bestFace, (WrappedBlockState)block);
            }
            if (sourcesHaveHitbox && (player.compensatedWorld.isWaterSourceBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ()) || player.compensatedWorld.getLavaFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ()) == 0.8888888955116272)) {
                double waterHeight = player.getClientVersion().isOlderThan(ClientVersion.V_1_13) ? 1.0 : player.compensatedWorld.getFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ());
                SimpleCollisionBox box = new SimpleCollisionBox(vector3i.getX(), vector3i.getY(), vector3i.getZ(), vector3i.getX() + 1, (double)vector3i.getY() + waterHeight, vector3i.getZ() + 1);
                Pair<Vector3dm, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(distance));
                if (intercept.first() != null) {
                    return new BlockHitData((Vector3i)vector3i, intercept.first(), intercept.second(), (WrappedBlockState)block);
                }
            }
            return null;
        });
    }

    public static BlockHitData traverseBlocks(GrimPlayer player, Vector3d start, Vector3d end, BiFunction<WrappedBlockState, Vector3i, BlockHitData> predicate) {
        double endX = GrimMath.lerp(-1.0E-7, end.x, start.x);
        double endY = GrimMath.lerp(-1.0E-7, end.y, start.y);
        double endZ = GrimMath.lerp(-1.0E-7, end.z, start.z);
        double startX = GrimMath.lerp(-1.0E-7, start.x, end.x);
        double startY = GrimMath.lerp(-1.0E-7, start.y, end.y);
        double startZ = GrimMath.lerp(-1.0E-7, start.z, end.z);
        int floorStartX = GrimMath.floor(startX);
        int floorStartY = GrimMath.floor(startY);
        int floorStartZ = GrimMath.floor(startZ);
        if (start.equals(end)) {
            return null;
        }
        WrappedBlockState state = player.compensatedWorld.getBlock(floorStartX, floorStartY, floorStartZ);
        BlockHitData apply = predicate.apply(state, new Vector3i(floorStartX, floorStartY, floorStartZ));
        if (apply != null) {
            return apply;
        }
        double xDiff = endX - startX;
        double yDiff = endY - startY;
        double zDiff = endZ - startZ;
        double xSign = Math.signum(xDiff);
        double ySign = Math.signum(yDiff);
        double zSign = Math.signum(zDiff);
        double posXInverse = xSign == 0.0 ? Double.MAX_VALUE : xSign / xDiff;
        double posYInverse = ySign == 0.0 ? Double.MAX_VALUE : ySign / yDiff;
        double posZInverse = zSign == 0.0 ? Double.MAX_VALUE : zSign / zDiff;
        double d12 = posXInverse * (xSign > 0.0 ? 1.0 - GrimMath.frac(startX) : GrimMath.frac(startX));
        double d13 = posYInverse * (ySign > 0.0 ? 1.0 - GrimMath.frac(startY) : GrimMath.frac(startY));
        double d14 = posZInverse * (zSign > 0.0 ? 1.0 - GrimMath.frac(startZ) : GrimMath.frac(startZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            if (d12 < d13) {
                if (d12 < d14) {
                    floorStartX = (int)((double)floorStartX + xSign);
                    d12 += posXInverse;
                } else {
                    floorStartZ = (int)((double)floorStartZ + zSign);
                    d14 += posZInverse;
                }
            } else if (d13 < d14) {
                floorStartY = (int)((double)floorStartY + ySign);
                d13 += posYInverse;
            } else {
                floorStartZ = (int)((double)floorStartZ + zSign);
                d14 += posZInverse;
            }
            if ((apply = predicate.apply(state = player.compensatedWorld.getBlock(floorStartX, floorStartY, floorStartZ), new Vector3i(floorStartX, floorStartY, floorStartZ))) == null) continue;
            return apply;
        }
        return null;
    }

    @Nullable
    public static HitData getNearestHitResult(GrimPlayer player, PacketEntity targetEntity, Vector3dm eyePos, Vector3dm lookVec) {
        double maxAttackDistance = player.compensatedEntities.self.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        double maxBlockDistance = player.compensatedEntities.self.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vector3d startingPos = new Vector3d(eyePos.getX(), eyePos.getY(), eyePos.getZ());
        Vector3dm startingVec = new Vector3dm(startingPos.getX(), startingPos.getY(), startingPos.getZ());
        Ray trace = new Ray(eyePos, lookVec);
        Vector3dm endVec = trace.getPointAtDistance(maxBlockDistance);
        Vector3d endPos = new Vector3d(endVec.getX(), endVec.getY(), endVec.getZ());
        BlockHitData blockHitData = WorldRayTrace.getTraverseResult(player, null, startingPos, startingVec, trace, endPos, false, true, maxBlockDistance, true);
        Vector3dm closestHitVec = null;
        PacketEntity closestEntity = null;
        double closestDistanceSquared = blockHitData != null ? blockHitData.getBlockHitLocation().distanceSquared(startingVec) : maxAttackDistance * maxAttackDistance;
        for (PacketEntity entity : player.compensatedEntities.entityMap.values().stream().filter(PacketEntity::canHit).toList()) {
            double distSquared;
            Pair<Vector3dm, BlockFace> intercept;
            SimpleCollisionBox box = null;
            if (entity.equals(targetEntity)) {
                box = entity.getPossibleCollisionBoxes();
                box.expand(player.checkManager.getPacketCheck(Reach.class).threshold);
                if (!player.packetStateData.didLastLastMovementIncludePosition || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                    box.expand(player.getMovementThreshold());
                }
                if (ReachUtils.isVecInside(box, eyePos)) {
                    return new EntityHitData(entity, eyePos);
                }
            } else {
                CollisionBox b = entity.getMinimumPossibleCollisionBoxes();
                if (b instanceof NoCollisionBox) continue;
                box = (SimpleCollisionBox)b;
                box.expand(-player.checkManager.getPacketCheck(Reach.class).threshold);
                if (!player.packetStateData.didLastLastMovementIncludePosition || player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                    box.expand(-player.getMovementThreshold());
                }
            }
            if (player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
                box.expand(0.1f);
            }
            if ((intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(Math.sqrt(closestDistanceSquared)))).first() == null || !((distSquared = intercept.first().distanceSquared(startingVec)) < closestDistanceSquared)) continue;
            closestDistanceSquared = distSquared;
            closestHitVec = intercept.first();
            closestEntity = entity;
        }
        return closestEntity == null ? blockHitData : new EntityHitData(closestEntity, closestHitVec);
    }

    @NotNull
    public static @NotNull Pair<@NotNull Double, @NotNull HitData> didRayTraceHit(GrimPlayer player, PacketEntity targetEntity, List<Pair<Vector3dm, Double>> possibleLookVecsAndEyeHeights, Vector3d from) {
        HitData firstObstruction = null;
        double firstObstructionDistanceSq = 0.0;
        for (Pair<Vector3dm, Double> vectorDoublePair : possibleLookVecsAndEyeHeights) {
            Vector3dm lookVec = vectorDoublePair.first();
            double eye = vectorDoublePair.second();
            Vector3dm eyes = new Vector3dm(from.getX(), from.getY() + eye, from.getZ());
            HitData hitResult = WorldRayTrace.getNearestHitResult(player, targetEntity, eyes, lookVec);
            if (hitResult instanceof EntityHitData && ((EntityHitData)hitResult).getEntity().equals(targetEntity)) {
                double distanceSquared = eyes.distanceSquared(hitResult.getBlockHitLocation());
                return new Pair<Double, HitData>(distanceSquared, hitResult);
            }
            if (hitResult == null || firstObstruction != null) continue;
            firstObstruction = hitResult;
            firstObstructionDistanceSq = eyes.distanceSquared(hitResult.getBlockHitLocation());
        }
        assert (firstObstruction != null);
        return new Pair<Double, Object>(firstObstructionDistanceSq, firstObstruction);
    }

    private static BlockHitData getTraverseResult(GrimPlayer player, @Nullable StateType heldItem, Vector3d startingPos, Vector3dm startingVec, Ray trace, Vector3d endPos, boolean sourcesHaveHitbox, boolean checkInside, double knownDistance, boolean shrinkBlocks) {
        return WorldRayTrace.traverseBlocks(player, startingPos, endPos, (block, vector3i) -> {
            CollisionBox data = HitboxData.getBlockHitbox(player, heldItem, player.getClientVersion(), block, false, vector3i.getX(), vector3i.getY(), vector3i.getZ());
            SimpleCollisionBox[] boxes = new SimpleCollisionBox[15];
            int size = data.downCast(boxes);
            double bestHitResult = Double.MAX_VALUE;
            Vector3dm bestHitLoc = null;
            BlockFace bestFace = null;
            for (int i = 0; i < size; ++i) {
                Pair<Vector3dm, BlockFace> intercept;
                if (shrinkBlocks) {
                    boxes[i].expand(-player.getMovementThreshold());
                }
                if ((intercept = ReachUtils.calculateIntercept(boxes[i], trace.getOrigin(), trace.getPointAtDistance(knownDistance))).first() == null) continue;
                Vector3dm hitLoc = intercept.first();
                if (checkInside && ReachUtils.isVecInside(boxes[i], trace.getOrigin())) {
                    return null;
                }
                if (!(hitLoc.distanceSquared(startingVec) < bestHitResult)) continue;
                bestHitResult = hitLoc.distanceSquared(startingVec);
                bestHitLoc = hitLoc;
                bestFace = intercept.second();
            }
            if (bestHitLoc != null) {
                return new BlockHitData((Vector3i)vector3i, bestHitLoc, bestFace, (WrappedBlockState)block);
            }
            if (sourcesHaveHitbox && (player.compensatedWorld.isWaterSourceBlock(vector3i.getX(), vector3i.getY(), vector3i.getZ()) || player.compensatedWorld.getLavaFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ()) == 0.8888888955116272)) {
                double waterHeight = player.compensatedWorld.getFluidLevelAt(vector3i.getX(), vector3i.getY(), vector3i.getZ());
                SimpleCollisionBox box = new SimpleCollisionBox(vector3i.getX(), vector3i.getY(), vector3i.getZ(), vector3i.getX() + 1, (double)vector3i.getY() + waterHeight, vector3i.getZ() + 1);
                Pair<Vector3dm, BlockFace> intercept = ReachUtils.calculateIntercept(box, trace.getOrigin(), trace.getPointAtDistance(knownDistance));
                if (intercept.first() != null) {
                    return new BlockHitData((Vector3i)vector3i, intercept.first(), intercept.second(), (WrappedBlockState)block);
                }
            }
            return null;
        });
    }

    @Generated
    private WorldRayTrace() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

