/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac;

import ac.grim.grimac.GrimExternalAPI;
import ac.grim.grimac.manager.AlertManagerImpl;
import ac.grim.grimac.manager.DiscordManager;
import ac.grim.grimac.manager.InitManager;
import ac.grim.grimac.manager.SpectateManager;
import ac.grim.grimac.manager.TickManager;
import ac.grim.grimac.manager.config.BaseConfigManager;
import ac.grim.grimac.manager.violationdatabase.ViolationDatabaseManager;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.PlayerDataManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public enum GrimAPI {
    INSTANCE;

    private final BaseConfigManager configManager = new BaseConfigManager();
    private final AlertManagerImpl alertManager = new AlertManagerImpl();
    private final SpectateManager spectateManager = new SpectateManager();
    private final DiscordManager discordManager = new DiscordManager();
    private final PlayerDataManager playerDataManager = new PlayerDataManager();
    private final TickManager tickManager = new TickManager();
    private final GrimExternalAPI externalAPI = new GrimExternalAPI(this);
    private ViolationDatabaseManager violationDatabaseManager;
    private InitManager initManager;
    private JavaPlugin plugin;
    private boolean criticalLoadFailure = false;

    public void load(JavaPlugin plugin) {
        this.plugin = plugin;
        this.violationDatabaseManager = new ViolationDatabaseManager((Plugin)plugin);
        this.initManager = new InitManager();
        this.initManager.load();
    }

    public void start(JavaPlugin plugin) {
        this.plugin = plugin;
        if (this.initManager != null) {
            this.initManager.start();
        }
        if (this.criticalLoadFailure) {
            LogUtil.error("GrimAC encountered one or more critical error(s) during initialization.");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    public void stop(JavaPlugin plugin) {
        this.plugin = plugin;
        if (this.initManager != null) {
            this.initManager.stop();
        }
    }

    public void signalCriticalFailure() {
        this.criticalLoadFailure = true;
    }

    public BaseConfigManager getConfigManager() {
        return this.configManager;
    }

    public AlertManagerImpl getAlertManager() {
        return this.alertManager;
    }

    public SpectateManager getSpectateManager() {
        return this.spectateManager;
    }

    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public TickManager getTickManager() {
        return this.tickManager;
    }

    public GrimExternalAPI getExternalAPI() {
        return this.externalAPI;
    }

    public ViolationDatabaseManager getViolationDatabaseManager() {
        return this.violationDatabaseManager;
    }

    public InitManager getInitManager() {
        return this.initManager;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isCriticalLoadFailure() {
        return this.criticalLoadFailure;
    }
}

