/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.debug;

import ac.grim.grimac.checks.debug.AbstractDebugHandler;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.buffer.ByteBufHelper;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPluginMessage;
import ac.grim.grimac.utils.collisions.datatypes.CollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.NoCollisionBox;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.Pair;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class HitboxDebugHandler
extends AbstractDebugHandler {
    private final Set<Player> listeners = new CopyOnWriteArraySet<Player>(new HashSet());

    public HitboxDebugHandler(GrimPlayer grimPlayer) {
        super(grimPlayer);
    }

    @Override
    public void toggleListener(Player player) {
        if (!this.listeners.remove(player)) {
            this.listeners.add(player);
        }
    }

    @Override
    public boolean toggleConsoleOutput() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHitboxData(Map<Integer, CollisionBox> hitboxes, Set<Integer> targetEntities, List<Pair<Vector, Double>> lookVecsAndEyeHeights, Vector basePos, boolean isPrediction, double reachDistance) {
        if (!this.isEnabled()) {
            return;
        }
        ByteBuf buffer = Unpooled.buffer();
        try {
            buffer.writeByte(1);
            byte global_flags = 0;
            global_flags = (byte)(global_flags | (isPrediction ? 1 : 0));
            buffer.writeByte((int)global_flags);
            buffer.writeDouble(reachDistance);
            this.writeVector(buffer, basePos);
            ByteBufHelper.writeVarInt(buffer, lookVecsAndEyeHeights.size());
            for (Pair<Vector, Double> pair : lookVecsAndEyeHeights) {
                Vector lookVec = pair.first();
                double eyeHeight = pair.second();
                buffer.writeDouble(eyeHeight);
                this.writeVector(buffer, lookVec);
            }
            ByteBufHelper.writeVarInt(buffer, hitboxes.size());
            for (Map.Entry entry : hitboxes.entrySet()) {
                int entityId = (Integer)entry.getKey();
                CollisionBox box = (CollisionBox)entry.getValue();
                ByteBufHelper.writeVarInt(buffer, entityId);
                byte flags = 0;
                flags = (byte)(flags | (targetEntities.contains(entityId) ? 1 : 0));
                flags = (byte)(flags | (box == NoCollisionBox.INSTANCE ? 2 : 0));
                buffer.writeByte((int)flags);
                if ((flags & 2) != 0) continue;
                SimpleCollisionBox simpleCollisionBox = (SimpleCollisionBox)box;
                buffer.writeDouble(simpleCollisionBox.minX);
                buffer.writeDouble(simpleCollisionBox.minY);
                buffer.writeDouble(simpleCollisionBox.minZ);
                buffer.writeDouble(simpleCollisionBox.maxX);
                buffer.writeDouble(simpleCollisionBox.maxY);
                buffer.writeDouble(simpleCollisionBox.maxZ);
            }
            byte[] data = new byte[buffer.readableBytes()];
            buffer.readBytes(data);
            WrapperPlayServerPluginMessage wrapperPlayServerPluginMessage = new WrapperPlayServerPluginMessage("grim:debug_hitbox", data);
            for (Player listener : this.listeners) {
                if (listener == null) continue;
                PacketEvents.getAPI().getPlayerManager().sendPacket((Object)listener, wrapperPlayServerPluginMessage);
            }
        }
        finally {
            buffer.release();
        }
    }

    @Override
    public boolean isEnabled() {
        return !this.listeners.isEmpty();
    }

    private void writeVector(ByteBuf buffer, Vector vector) {
        buffer.writeDouble(vector.getX());
        buffer.writeDouble(vector.getY());
        buffer.writeDouble(vector.getZ());
    }
}

