/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.breaking;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockBreakCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.anticheat.update.BlockBreak;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;

@CheckData(name="PositionBreakA")
public class PositionBreakA
extends Check
implements BlockBreakCheck {
    public PositionBreakA(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockBreak(BlockBreak blockBreak) {
        boolean flag;
        if (this.player.inVehicle() || blockBreak.action == DiggingAction.CANCELLED_DIGGING || blockBreak.block.getType() == StateTypes.REDSTONE_WIRE) {
            return;
        }
        SimpleCollisionBox combined = blockBreak.getCombinedBox();
        double[] possibleEyeHeights = this.player.getPossibleEyeHeights();
        double minEyeHeight = Double.MAX_VALUE;
        double maxEyeHeight = Double.MIN_VALUE;
        for (double height : possibleEyeHeights) {
            minEyeHeight = Math.min(minEyeHeight, height);
            maxEyeHeight = Math.max(maxEyeHeight, height);
        }
        SimpleCollisionBox eyePositions = new SimpleCollisionBox(this.player.x, this.player.y + minEyeHeight, this.player.z, this.player.x, this.player.y + maxEyeHeight, this.player.z);
        if (!this.player.packetStateData.didLastMovementIncludePosition || this.player.canSkipTicks()) {
            eyePositions.expand(this.player.getMovementThreshold());
        }
        if (eyePositions.isIntersected(combined)) {
            return;
        }
        switch (blockBreak.face) {
            case NORTH: {
                flag = eyePositions.minZ > combined.minZ;
                break;
            }
            case SOUTH: {
                flag = eyePositions.maxZ < combined.maxZ;
                break;
            }
            case EAST: {
                flag = eyePositions.maxX < combined.maxX;
                break;
            }
            case WEST: {
                flag = eyePositions.minX > combined.minX;
                break;
            }
            case UP: {
                flag = eyePositions.maxY < combined.maxY;
                break;
            }
            case DOWN: {
                flag = eyePositions.minY > combined.minY;
                break;
            }
            default: {
                flag = false;
            }
        }
        if (flag && this.flagAndAlert("action=" + (Object)((Object)blockBreak.action) + ", face=" + (Object)((Object)blockBreak.face)) && this.shouldModifyPackets()) {
            blockBreak.cancel();
        }
    }
}

