/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.crash;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUseItem;

@CheckData(name="CrashG", description="Sent negative sequence id")
public class CrashG
extends Check
implements PacketCheck {
    public CrashG(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientUseItem use;
        WrapperPlayClientPlayerDigging dig;
        WrapperPlayClientPlayerBlockPlacement place;
        if (!this.isSupportedVersion()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT && (place = new WrapperPlayClientPlayerBlockPlacement(event)).getSequence() < 0) {
            this.flagAndAlert();
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING && (dig = new WrapperPlayClientPlayerDigging(event)).getSequence() < 0) {
            this.flagAndAlert();
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
        if (event.getPacketType() == PacketType.Play.Client.USE_ITEM && (use = new WrapperPlayClientUseItem(event)).getSequence() < 0) {
            this.flagAndAlert();
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }

    private boolean isSupportedVersion() {
        return this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_19) && PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19);
    }
}

