/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.multiactions;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;

@CheckData(name="MultiActionsC", description="Clicked in inventory while sprinting", experimental=true)
public class MultiActionsC
extends Check
implements PacketCheck {
    private boolean serverOpenedInventoryThisTick;

    public MultiActionsC(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW && this.player.isSprinting && !this.player.isSwimming && !this.serverOpenedInventoryThisTick && this.flagAndAlert() && this.shouldModifyPackets()) {
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
        if (this.isTickPacket(event.getPacketType())) {
            this.serverOpenedInventoryThisTick = false;
        }
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            this.player.latencyUtils.addRealTimeTask(this.player.lastTransactionSent.get(), () -> {
                this.serverOpenedInventoryThisTick = true;
            });
        }
    }
}

