/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.scaffolding;

import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.BlockHitData;
import ac.grim.grimac.utils.nmsutil.BlockRayTrace;
import ac.grim.grimac.utils.nmsutil.ReachUtilsPrimitives;
import com.viaversion.viaversion.util.Triple;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@CheckData(name="LineOfSightPlace", experimental=true)
public class LineOfSightPlace
extends BlockPlaceCheck {
    private double flagBuffer = 0.0;
    private boolean ignorePost = false;
    private boolean useBlockWhitelist;
    private HashSet<StateType> blockWhitelist;
    private final SimpleCollisionBox[] collisionBoxBuffer = new SimpleCollisionBox[15];
    public final Set<Triple<Vector3i, WrappedBlockState, Byte>> blocksChangedList = ConcurrentHashMap.newKeySet();

    public LineOfSightPlace(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        if (this.checkIfShouldSkip(place)) {
            return;
        }
        if (this.flagBuffer > 0.0 && !this.didRayTraceHit(place)) {
            this.ignorePost = true;
            if (this.flagAndAlert("pre-flying: " + this.player.compensatedWorld.getBlock(place.getPlacedAgainstBlockLocation()).getType()) && this.shouldModifyPackets() && this.shouldCancel()) {
                place.resync();
            }
        }
    }

    @Override
    public void onPostFlyingBlockPlace(BlockPlace place) {
        if (this.checkIfShouldSkip(place)) {
            return;
        }
        if (this.ignorePost) {
            this.ignorePost = false;
            return;
        }
        boolean hit = this.didRayTraceHit(place);
        if (!hit) {
            this.flagBuffer = 1.0;
            this.flagAndAlert("post-flying: " + this.player.compensatedWorld.getBlock(place.getPlacedAgainstBlockLocation()).getType());
        } else {
            this.flagBuffer = Math.max(0.0, this.flagBuffer - 0.1);
        }
    }

    private boolean checkIfShouldSkip(BlockPlace place) {
        StateType targetBlockStateType = this.player.compensatedWorld.getBlock(place.getPlacedAgainstBlockLocation()).getType();
        if (this.player.gamemode == GameMode.SPECTATOR) {
            return true;
        }
        if (targetBlockStateType == StateTypes.REDSTONE_WIRE) {
            return true;
        }
        if (this.player.compensatedWorld.isNearHardEntity(this.player.boundingBox.copy().expand(4.0))) {
            return true;
        }
        if (this.useBlockWhitelist) {
            return !this.isBlockTypeWhitelisted(targetBlockStateType);
        }
        return false;
    }

    private boolean didRayTraceHit(BlockPlace place) {
        double[] possibleEyeHeights = this.player.getPossibleEyeHeights();
        double minEyeHeight = Double.MAX_VALUE;
        double maxEyeHeight = Double.MIN_VALUE;
        for (double height : possibleEyeHeights) {
            minEyeHeight = Math.min(minEyeHeight, height);
            maxEyeHeight = Math.max(maxEyeHeight, height);
        }
        double movementThreshold = this.player.getMovementThreshold();
        SimpleCollisionBox eyePositions = new SimpleCollisionBox(this.player.x, this.player.y + minEyeHeight, this.player.z, this.player.x, this.player.y + maxEyeHeight, this.player.z);
        eyePositions.expand(movementThreshold);
        int[] interactBlockVec = new int[]{place.blockPosition.x, place.blockPosition.y, place.blockPosition.z};
        BlockFace expectedBlockFace = place.getDirection();
        if (eyePositions.isIntersected(new SimpleCollisionBox(interactBlockVec[0], (double)interactBlockVec[1], (double)interactBlockVec[2]))) {
            return true;
        }
        float[][] possibleLookDirs = this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? new float[][]{{this.player.xRot, this.player.yRot}, {this.player.lastXRot, this.player.lastYRot}, {this.player.lastXRot, this.player.yRot}} : (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8) ? new float[][]{{this.player.xRot, this.player.yRot}} : new float[][]{{this.player.xRot, this.player.yRot}, {this.player.lastXRot, this.player.yRot}});
        double maxDistance = this.player.compensatedEntities.self.getAttributeValue(Attributes.PLAYER_BLOCK_INTERACTION_RANGE);
        double[][] offsets = new double[][]{{0.0, 0.0, 0.0}, {movementThreshold, 0.0, 0.0}, {-movementThreshold, 0.0, 0.0}, {0.0, movementThreshold, 0.0}, {0.0, -movementThreshold, 0.0}, {0.0, 0.0, movementThreshold}, {0.0, 0.0, -movementThreshold}};
        double[] eyePosition = new double[3];
        double[] eyeLookDir = new double[3];
        for (double eyeHeight : possibleEyeHeights) {
            for (float[] lookDir : possibleLookDirs) {
                for (double[] offset : offsets) {
                    eyePosition[0] = this.player.x + offset[0];
                    eyePosition[1] = this.player.y + eyeHeight + offset[1];
                    eyePosition[2] = this.player.z + offset[2];
                    ReachUtilsPrimitives.getLook(this.player, lookDir[0], lookDir[1], eyeLookDir);
                    if (!this.didRayTraceHitTargetBlock(eyePosition, eyeLookDir, maxDistance, interactBlockVec, expectedBlockFace)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean didRayTraceHitTargetBlock(double[] eyePos, double[] eyeDir, double maxDistance, int[] targetBlockVec, BlockFace expectedBlockFace) {
        BlockHitData hitData = BlockRayTrace.getNearestHitResult(this.player, eyePos, eyeDir, maxDistance, maxDistance, targetBlockVec, expectedBlockFace, this.collisionBoxBuffer, false);
        return hitData != null && hitData.success != false;
    }

    private boolean isBlockTypeWhitelisted(StateType type) {
        return this.blockWhitelist.contains(type);
    }

    @Override
    public void onReload(ConfigManager config) {
        this.useBlockWhitelist = config.getBooleanElse("LineOfSightPlace.use-block-whitelist", false);
        this.blockWhitelist = new HashSet();
        List<String> blocks = config.getStringList("LineOfSightPlace.block-whitelist");
        for (String block : blocks) {
            this.blockWhitelist.add(StateTypes.getByName(block));
        }
    }
}

