/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.scaffolding;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;

@CheckData(name="PositionPlace")
public class PositionPlace
extends BlockPlaceCheck {
    public PositionPlace(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        if (place.getMaterial() == StateTypes.SCAFFOLDING) {
            return;
        }
        SimpleCollisionBox combined = this.getCombinedBox(place);
        double[] possibleEyeHeights = this.player.getPossibleEyeHeights();
        double minEyeHeight = Double.MAX_VALUE;
        double maxEyeHeight = Double.MIN_VALUE;
        for (double height : possibleEyeHeights) {
            minEyeHeight = Math.min(minEyeHeight, height);
            maxEyeHeight = Math.max(maxEyeHeight, height);
        }
        double movementThreshold = !this.player.packetStateData.didLastMovementIncludePosition || this.player.canSkipTicks() ? this.player.getMovementThreshold() : 0.0;
        SimpleCollisionBox eyePositions = new SimpleCollisionBox(this.player.x, this.player.y + minEyeHeight, this.player.z, this.player.x, this.player.y + maxEyeHeight, this.player.z);
        eyePositions.expand(movementThreshold);
        if (eyePositions.isIntersected(combined)) {
            return;
        }
        boolean flag = false;
        switch (place.getDirection()) {
            case NORTH: {
                flag = eyePositions.minZ > combined.minZ;
                break;
            }
            case SOUTH: {
                flag = eyePositions.maxZ < combined.maxZ;
                break;
            }
            case EAST: {
                flag = eyePositions.maxX < combined.maxX;
                break;
            }
            case WEST: {
                flag = eyePositions.minX > combined.minX;
                break;
            }
            case UP: {
                flag = eyePositions.maxY < combined.maxY;
                break;
            }
            case DOWN: {
                boolean bl = flag = eyePositions.minY > combined.minY;
            }
        }
        if (flag && this.flagAndAlert() && this.shouldModifyPackets() && this.shouldCancel()) {
            place.resync();
        }
    }
}

