/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.commands;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.commands.GrimLog;
import ac.grim.grimac.shaded.acf.BaseCommand;
import ac.grim.grimac.shaded.acf.annotation.CommandAlias;
import ac.grim.grimac.shaded.acf.annotation.CommandPermission;
import ac.grim.grimac.shaded.acf.annotation.Subcommand;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.viaversion.ViaVersionUtil;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="grim|grimac")
public class GrimDump
extends BaseCommand {
    private String link = null;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final boolean PAPER = GrimDump.hasClass("com.destroystokyo.paper.PaperConfig") || GrimDump.hasClass("io.papermc.paper.configuration.Configuration");

    @Subcommand(value="dump")
    @CommandPermission(value="grim.dump")
    public void onCommand(CommandSender sender) {
        if (this.link != null) {
            MessageUtil.sendMessage(sender, MessageUtil.miniMessage(GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("upload-log", "%prefix% &fUploaded debug to: %url%").replace("%url%", this.link)));
            return;
        }
        GrimLog.sendLogAsync(sender, this.generateDump(), string -> {
            this.link = string;
        }, "text/yaml");
    }

    private String generateDump() {
        JsonObject base = new JsonObject();
        base.addProperty("type", "dump");
        base.addProperty("timestamp", (Number)System.currentTimeMillis());
        JsonObject versions = new JsonObject();
        base.add("versions", (JsonElement)versions);
        versions.addProperty("grim", GrimAPI.INSTANCE.getExternalAPI().getGrimVersion());
        versions.addProperty("packetevents", PacketEvents.getAPI().getVersion().toString());
        versions.addProperty("server", PacketEvents.getAPI().getServerManager().getVersion().getReleaseName());
        versions.addProperty("implementation", Bukkit.getVersion());
        JsonArray properties = new JsonArray();
        base.add("properties", (JsonElement)properties);
        if (PAPER) {
            properties.add("paper");
        }
        if (FoliaScheduler.isFolia()) {
            properties.add("folia");
        }
        if (ViaVersionUtil.isAvailable()) {
            properties.add("viaversion");
        }
        JsonObject system = new JsonObject();
        base.add("system", (JsonElement)system);
        system.addProperty("os", System.getProperty("os.name"));
        system.addProperty("java", System.getProperty("java.version"));
        JsonArray plugins = new JsonArray();
        base.add("plugins", (JsonElement)plugins);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            JsonObject pluginJson = new JsonObject();
            pluginJson.addProperty("enabled", Boolean.valueOf(plugin.isEnabled()));
            pluginJson.addProperty("name", plugin.getName());
            pluginJson.addProperty("version", plugin.getDescription().getVersion());
            plugins.add((JsonElement)pluginJson);
        }
        return this.gson.toJson((JsonElement)base);
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

