/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.commands;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.violationdatabase.Violation;
import ac.grim.grimac.manager.violationdatabase.ViolationDatabaseManager;
import ac.grim.grimac.shaded.acf.BaseCommand;
import ac.grim.grimac.shaded.acf.annotation.CommandAlias;
import ac.grim.grimac.shaded.acf.annotation.CommandCompletion;
import ac.grim.grimac.shaded.acf.annotation.CommandPermission;
import ac.grim.grimac.shaded.acf.annotation.Optional;
import ac.grim.grimac.shaded.acf.annotation.Subcommand;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="grim|grimac")
public class GrimHistory
extends BaseCommand {
    @Subcommand(value="history|hist")
    @CommandPermission(value="grim.history")
    @CommandAlias(value="gh")
    @CommandCompletion(value="@players")
    public void onLogs(CommandSender sender, String target, @Optional Integer page) {
        int entriesPerPage = GrimAPI.INSTANCE.getConfigManager().getConfig().getIntElse("history.entries-per-page", 15);
        String header = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("grim-history-header", "%prefix% &bShowing logs for &f%player% (&f%page%&b/&f%maxPages%&f)");
        String logFormat = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("grim-history-entry", "%prefix% &8[&f%server%&8] &bFailed &f%check% (x&c%vl%&f) &7%verbose% (&b%timeago% ago&7)");
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), __ -> {
            OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)target);
            int notNullPage = page == null ? 1 : page;
            ViolationDatabaseManager violations = GrimAPI.INSTANCE.getViolationDatabaseManager();
            int logCount = violations.getLogCount(targetPlayer.getUniqueId());
            List<Violation> logs = violations.getViolations(targetPlayer.getUniqueId(), notNullPage, entriesPerPage);
            int maxPages = (int)Math.ceil((float)logCount / (float)entriesPerPage);
            MessageUtil.sendMessage(sender, MessageUtil.miniMessage(MessageUtil.replacePlaceholders(sender, header.replace("%player%", targetPlayer.getName()).replace("%page%", String.valueOf(notNullPage)).replace("%maxPages%", String.valueOf(maxPages)))));
            for (int i = logs.size() - 1; i >= 0; --i) {
                Violation log = logs.get(i);
                MessageUtil.sendMessage(sender, MessageUtil.miniMessage(MessageUtil.replacePlaceholders(sender, logFormat.replace("%player%", targetPlayer.getName()).replace("%check%", log.getCheckName()).replace("%verbose%", log.getVerbose()).replace("%vl%", String.valueOf(log.getVl())).replace("%timeago%", this.getTimeAgo(log.getCreatedAt())).replace("%server%", log.getServerName()))));
            }
        });
    }

    protected String getTimeAgo(Date date) {
        long durationMillis = new Date().getTime() - date.getTime();
        long days = TimeUnit.MILLISECONDS.toDays(durationMillis);
        long hours = TimeUnit.MILLISECONDS.toHours(durationMillis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(durationMillis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(durationMillis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days).append("d ");
        }
        if (hours > 0L) {
            result.append(hours).append("h ");
        }
        if (minutes > 0L) {
            result.append(minutes).append("m ");
        }
        if (seconds > 0L) {
            result.append(seconds).append("s");
        }
        return result.toString().trim();
    }
}

