/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.commands;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.shaded.acf.BaseCommand;
import ac.grim.grimac.shaded.acf.annotation.CommandAlias;
import ac.grim.grimac.shaded.acf.annotation.CommandPermission;
import ac.grim.grimac.shaded.acf.annotation.Subcommand;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;
import ac.grim.grimac.shaded.kyori.adventure.text.TextComponent;
import ac.grim.grimac.shaded.kyori.adventure.text.event.ClickEvent;
import ac.grim.grimac.shaded.kyori.adventure.text.format.NamedTextColor;
import ac.grim.grimac.shaded.kyori.adventure.text.format.TextDecoration;
import ac.grim.grimac.utils.anticheat.LogUtil;
import ac.grim.grimac.utils.anticheat.MessageUtil;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="grim|grimac")
public class GrimVersion
extends BaseCommand {
    private static long lastCheck;
    private static final AtomicReference<Component> updateMessage;

    @Subcommand(value="version")
    @CommandPermission(value="grim.version")
    public void onCommand(CommandSender sender) {
        GrimVersion.checkForUpdatesAsync(sender);
    }

    public static void checkForUpdatesAsync(CommandSender sender) {
        String current = GrimAPI.INSTANCE.getExternalAPI().getGrimVersion();
        MessageUtil.sendMessage(sender, (Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("Grim Version: ").color(NamedTextColor.GRAY))).append(Component.text(current).color(NamedTextColor.AQUA))).build());
        long now = System.currentTimeMillis();
        if (now - lastCheck < 60000L) {
            Component message = updateMessage.get();
            if (message != null) {
                MessageUtil.sendMessage(sender, message);
            }
            return;
        }
        lastCheck = now;
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)GrimAPI.INSTANCE.getPlugin(), dummy -> GrimVersion.checkForUpdates(sender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForUpdates(CommandSender sender) {
        String current = GrimAPI.INSTANCE.getExternalAPI().getGrimVersion();
        HttpURLConnection connection = null;
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/LJNGWSvH/version");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "GrimAnticheat/Grim/" + GrimAPI.INSTANCE.getExternalAPI().getGrimVersion());
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                Object msg = updateMessage.get();
                if (msg == null) {
                    msg = ((TextComponent.Builder)Component.text().append(Component.text("Failed to check latest version.").color(NamedTextColor.RED))).build();
                }
                MessageUtil.sendMessage(sender, (Component)msg);
                LogUtil.error("Failed to check latest GrimAC version. Response code: " + responseCode);
                return;
            }
            try (InputStream inputStream = connection.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JsonObject object = JsonParser.parseString((String)response.toString()).getAsJsonArray().get(0).getAsJsonObject();
                String latest = object.get("version_number").getAsString();
                Status status = GrimVersion.compareVersions(current, latest);
                Object msg = null;
                switch (status.ordinal()) {
                    case 0: {
                        msg = Component.text("You are using a development version of GrimAC").color(NamedTextColor.LIGHT_PURPLE);
                        break;
                    }
                    case 1: {
                        msg = Component.text("You are using the latest version of GrimAC").color(NamedTextColor.GREEN);
                        break;
                    }
                    case 2: {
                        msg = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text("New GrimAC version found!").color(NamedTextColor.AQUA))).append(Component.text(" Version ").color(NamedTextColor.GRAY))).append(((TextComponent)Component.text(latest).color(NamedTextColor.GRAY)).decorate(TextDecoration.ITALIC))).append(Component.text(" is available to be downloaded here: ").color(NamedTextColor.GRAY))).append(((TextComponent)((TextComponent)Component.text("https://modrinth.com/plugin/grimac").color(NamedTextColor.GRAY)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.openUrl("https://modrinth.com/plugin/grimac")))).build();
                    }
                }
                updateMessage.set((Component)msg);
                MessageUtil.sendMessage(sender, (Component)msg);
            }
        }
        catch (Exception e) {
            MessageUtil.sendMessage(sender, Component.text("Failed to check latest version.").color(NamedTextColor.RED));
            LogUtil.error("Failed to check latest GrimAC version.", e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static Status compareVersions(String local, String latest) {
        if (local.equals(latest)) {
            return Status.UPDATED;
        }
        String[] localParts = local.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(localParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            int latestPart;
            int localPart = i < localParts.length ? Integer.parseInt(localParts[i]) : 0;
            int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            if (localPart < latestPart) {
                return Status.OUTDATED;
            }
            if (localPart <= latestPart) continue;
            return Status.AHEAD;
        }
        return Status.UPDATED;
    }

    static {
        updateMessage = new AtomicReference();
    }

    private static enum Status {
        AHEAD,
        UPDATED,
        OUTDATED;

    }
}

