/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.init.load;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.chat.ChatTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.data.EntityDataTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.enchantment.type.EnchantmentTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.type.ItemTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.particle.type.ParticleTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.PEVersion;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import ac.grim.grimac.utils.anticheat.LogUtil;
import java.util.concurrent.Executors;
import org.bukkit.plugin.Plugin;

public class PacketEventsInit
implements Initable {
    PEVersion NEWEST_UNSUPPORTED_PE_VERSION = new PEVersion(2, 7, 0);

    @Override
    public void start() {
        LogUtil.info("Loading PacketEvents...");
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)GrimAPI.INSTANCE.getPlugin()));
        if (!this.checkPacketEventsVersion()) {
            GrimAPI.INSTANCE.signalCriticalFailure();
            throw new RuntimeException("\n******************************************************\nGrimAC requires PacketEvents > " + this.NEWEST_UNSUPPORTED_PE_VERSION + "\nPlease update PacketEvents to a compatible version.\nThis is a critical error. GrimAC will be disabled.\n*****************************************************");
        }
        PacketEvents.getAPI().getSettings().fullStackTrace(true).kickOnPacketException(true).checkForUpdates(false).reEncodeByDefault(false).debug(false);
        PacketEvents.getAPI().load();
        Executors.defaultThreadFactory().newThread(() -> {
            StateTypes.AIR.getName();
            ItemTypes.AIR.getName();
            EntityTypes.PLAYER.getParent();
            EntityDataTypes.BOOLEAN.getName();
            ChatTypes.CHAT.getName();
            EnchantmentTypes.ALL_DAMAGE_PROTECTION.getName();
            ParticleTypes.DUST.getName();
        }).start();
    }

    private boolean checkPacketEventsVersion() {
        PEVersion peVersion = PacketEvents.getAPI().getVersion();
        return peVersion.isNewerThan(this.NEWEST_UNSUPPORTED_PE_VERSION);
    }
}

