/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.init.start;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.GrimUser;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PlaceholderAPIExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "grim";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", GrimAPI.INSTANCE.getPlugin().getDescription().getAuthors());
    }

    @NotNull
    public String getVersion() {
        return GrimAPI.INSTANCE.getExternalAPI().getGrimVersion();
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public List<String> getPlaceholders() {
        Set<String> placeholders = GrimAPI.INSTANCE.getExternalAPI().getStaticReplacements().keySet();
        placeholders.addAll(GrimAPI.INSTANCE.getExternalAPI().getVariableReplacements().keySet());
        return Collections.unmodifiableList(new ArrayList<String>(placeholders));
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        for (Map.Entry<String, String> entry : GrimAPI.INSTANCE.getExternalAPI().getStaticReplacements().entrySet()) {
            String key = entry.getKey().equals("%grim_version%") ? "version" : entry.getKey().replaceAll("%", "");
            if (!params.equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            GrimPlayer grimPlayer = GrimAPI.INSTANCE.getPlayerDataManager().getPlayer(player);
            if (grimPlayer == null) {
                return null;
            }
            for (Map.Entry<String, Function<GrimUser, String>> entry : GrimAPI.INSTANCE.getExternalAPI().getVariableReplacements().entrySet()) {
                String key = entry.getKey().equals("%player%") ? "player" : "player_" + entry.getKey().replaceAll("%", "");
                if (!params.equalsIgnoreCase(key)) continue;
                return entry.getValue().apply(grimPlayer);
            }
        }
        return null;
    }
}

