/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.violationdatabase;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.manager.violationdatabase.Violation;
import ac.grim.grimac.manager.violationdatabase.ViolationDatabase;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.jetbrains.annotations.NotNull;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class SQLiteViolationDatabase
implements ViolationDatabase {
    private final Plugin plugin;
    private Connection openConnection;

    public SQLiteViolationDatabase(@NotNull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void connect() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not load SQLite driver", e);
        }
        try (Connection connection = this.getConnection();){
            connection.prepareStatement("CREATE TABLE IF NOT EXISTS violations(id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, server VARCHAR(255) NOT NULL, uuid CHARACTER(36) NOT NULL, check_name TEXT NOT NULL, verbose TEXT NOT NULL, vl INTEGER NOT NULL, created_at BIGINT NOT NULL)").execute();
            connection.prepareStatement("CREATE INDEX IF NOT EXISTS idx_violations_uuid ON violations(uuid)").execute();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to generate violations database:", ex);
        }
    }

    @Override
    public synchronized void logAlert(GrimPlayer player, String verbose, String checkName, int vls) {
        try (Connection connection = this.getConnection();
             PreparedStatement insertLog = connection.prepareStatement("INSERT INTO violations (server, uuid, check_name, verbose, vl, created_at) VALUES (?, ?, ?, ?, ?, ?)");){
            insertLog.setString(1, GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("history.server-name", "Prison"));
            insertLog.setString(2, player.getUniqueId().toString());
            insertLog.setString(3, verbose);
            insertLog.setString(4, checkName);
            insertLog.setInt(5, vls);
            insertLog.setLong(6, System.currentTimeMillis());
            insertLog.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to insert violation:", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized int getLogCount(UUID player) {
        try (Connection connection = this.getConnection();
             PreparedStatement fetchLogs = connection.prepareStatement("SELECT COUNT(*) FROM violations WHERE uuid = ?");){
            fetchLogs.setString(1, player.toString());
            ResultSet resultSet = fetchLogs.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to fetch number of violations:", ex);
        }
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized List<Violation> getViolations(UUID player, int page, int limit) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try (Connection connection = this.getConnection();){
            List<Violation> list;
            block14: {
                PreparedStatement fetchLogs = connection.prepareStatement("SELECT server, uuid, check_name, verbose, vl, created_at FROM violations WHERE uuid = ? ORDER BY created_at DESC LIMIT ? OFFSET ?");
                try {
                    fetchLogs.setString(1, player.toString());
                    fetchLogs.setInt(2, limit);
                    fetchLogs.setInt(3, (page - 1) * limit);
                    list = Violation.fromResultSet(fetchLogs.executeQuery());
                    if (fetchLogs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (fetchLogs != null) {
                        try {
                            fetchLogs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fetchLogs.close();
            }
            return list;
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to fetch violations:", ex);
            return violations;
        }
    }

    @Override
    public void disconnect() {
        try {
            if (this.openConnection != null && !this.openConnection.isClosed()) {
                this.openConnection.close();
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to close connection", ex);
        }
    }

    protected synchronized Connection getConnection() throws SQLException {
        if (this.openConnection == null || this.openConnection.isClosed()) {
            this.openConnection = this.openConnection();
        }
        return this.openConnection;
    }

    protected Connection openConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + File.separator + "violations.sqlite");
    }
}

