/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.violationdatabase;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class Violation {
    private final String serverName;
    private final UUID playerUUID;
    private final String checkName;
    private final String verbose;
    private final int vl;
    private final Date createdAt;

    public static List<Violation> fromResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        while (resultSet.next()) {
            String server = resultSet.getString("server");
            UUID player = UUID.fromString(resultSet.getString("uuid"));
            String checkName = resultSet.getString("check_name");
            String verbose = resultSet.getString("verbose");
            int vl = resultSet.getInt("vl");
            Date createdAt = new Date(resultSet.getLong("created_at"));
            violations.add(new Violation(server, player, checkName, verbose, vl, createdAt));
        }
        return violations;
    }

    public Violation(String serverName, UUID playerUUID, String checkName, String verbose, int vl, Date createdAt) {
        this.serverName = serverName;
        this.playerUUID = playerUUID;
        this.checkName = checkName;
        this.verbose = verbose;
        this.vl = vl;
        this.createdAt = createdAt;
    }

    public String getServerName() {
        return this.serverName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public String getCheckName() {
        return this.checkName;
    }

    public String getVerbose() {
        return this.verbose;
    }

    public int getVl() {
        return this.vl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Violation)) {
            return false;
        }
        Violation other = (Violation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVl() != other.getVl()) {
            return false;
        }
        String this$serverName = this.getServerName();
        String other$serverName = other.getServerName();
        if (this$serverName == null ? other$serverName != null : !this$serverName.equals(other$serverName)) {
            return false;
        }
        UUID this$playerUUID = this.getPlayerUUID();
        UUID other$playerUUID = other.getPlayerUUID();
        if (this$playerUUID == null ? other$playerUUID != null : !((Object)this$playerUUID).equals(other$playerUUID)) {
            return false;
        }
        String this$checkName = this.getCheckName();
        String other$checkName = other.getCheckName();
        if (this$checkName == null ? other$checkName != null : !this$checkName.equals(other$checkName)) {
            return false;
        }
        String this$verbose = this.getVerbose();
        String other$verbose = other.getVerbose();
        if (this$verbose == null ? other$verbose != null : !this$verbose.equals(other$verbose)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Violation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVl();
        String $serverName = this.getServerName();
        result = result * 59 + ($serverName == null ? 43 : $serverName.hashCode());
        UUID $playerUUID = this.getPlayerUUID();
        result = result * 59 + ($playerUUID == null ? 43 : ((Object)$playerUUID).hashCode());
        String $checkName = this.getCheckName();
        result = result * 59 + ($checkName == null ? 43 : $checkName.hashCode());
        String $verbose = this.getVerbose();
        result = result * 59 + ($verbose == null ? 43 : $verbose.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "Violation(serverName=" + this.getServerName() + ", playerUUID=" + this.getPlayerUUID() + ", checkName=" + this.getCheckName() + ", verbose=" + this.getVerbose() + ", vl=" + this.getVl() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

