/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.manager.violationdatabase;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.api.config.ConfigManager;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.manager.violationdatabase.MySQLViolationDatabase;
import ac.grim.grimac.manager.violationdatabase.SQLiteViolationDatabase;
import ac.grim.grimac.manager.violationdatabase.Violation;
import ac.grim.grimac.manager.violationdatabase.ViolationDatabase;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class ViolationDatabaseManager
implements Initable {
    private final Plugin plugin;
    private ViolationDatabase database;

    public ViolationDatabaseManager(Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void start() {
        ConfigManager config = GrimAPI.INSTANCE.getConfigManager().getConfig();
        String dbType = config.getStringElse("history.database.type", "SQLITE").toUpperCase();
        if (dbType.equals("SQLITE")) {
            this.database = new SQLiteViolationDatabase(this.plugin);
        } else if (dbType.equals("MYSQL")) {
            String url = config.getStringElse("history.database.host", "jdbc:mysql://localhost:3306/");
            String database = config.getStringElse("history.database.database", "grimac");
            String username = config.getStringElse("history.database.username", "root");
            String password = config.getStringElse("history.database.password", "password");
            this.database = new MySQLViolationDatabase(this.plugin, url, database, username, password);
        } else {
            this.database = new SQLiteViolationDatabase(this.plugin);
            this.plugin.getLogger().log(Level.SEVERE, "Invalid database type: " + dbType + ". Defaulting to SQLite");
        }
        this.database.connect();
    }

    public void logAlert(GrimPlayer player, String verbose, String checkName, int vls) {
        FoliaScheduler.getAsyncScheduler().runNow(this.plugin, __ -> this.database.logAlert(player, verbose, checkName, vls));
    }

    public int getLogCount(UUID player) {
        return this.database.getLogCount(player);
    }

    public List<Violation> getViolations(UUID player, int page, int limit) {
        return this.database.getViolations(player, page, limit);
    }
}

