/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.predictionengine;

import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.attribute.Attributes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.BlockFace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.LastInstance;
import ac.grim.grimac.utils.data.VectorData;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.data.packetentity.PacketEntityRideable;
import ac.grim.grimac.utils.data.packetentity.PacketEntityStrider;
import ac.grim.grimac.utils.lists.EvictingQueue;
import ac.grim.grimac.utils.nmsutil.BoundingBoxSize;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bukkit.util.Vector;

public class UncertaintyHandler {
    private final GrimPlayer player;
    public EvictingQueue<Double> pistonX = new EvictingQueue(5);
    public EvictingQueue<Double> pistonY = new EvictingQueue(5);
    public EvictingQueue<Double> pistonZ = new EvictingQueue(5);
    public boolean isStepMovement;
    public HashSet<BlockFace> slimePistonBounces;
    public double xNegativeUncertainty = 0.0;
    public double xPositiveUncertainty = 0.0;
    public double zNegativeUncertainty = 0.0;
    public double zPositiveUncertainty = 0.0;
    public double yNegativeUncertainty = 0.0;
    public double yPositiveUncertainty = 0.0;
    public double thisTickSlimeBlockUncertainty = 0.0;
    public double nextTickSlimeBlockUncertainty = 0.0;
    public boolean onGroundUncertain = false;
    public boolean lastPacketWasGroundPacket = false;
    public boolean isSteppingOnSlime = false;
    public boolean isSteppingOnIce = false;
    public boolean isSteppingOnHoney = false;
    public boolean wasSteppingOnBouncyBlock = false;
    public boolean isSteppingOnBouncyBlock = false;
    public boolean isSteppingNearBubbleColumn = false;
    public boolean isSteppingNearScaffolding = false;
    public boolean isSteppingNearShulker = false;
    public boolean isNearGlitchyBlock = false;
    public boolean isOrWasNearGlitchyBlock = false;
    public boolean claimingLeftStuckSpeed = false;
    public boolean lastMovementWasZeroPointZeroThree = false;
    public boolean lastMovementWasUnknown003VectorReset = false;
    public boolean wasZeroPointThreeVertically = false;
    public EvictingQueue<Integer> collidingEntities = new EvictingQueue(3);
    public EvictingQueue<Integer> riptideEntities = new EvictingQueue(3);
    public List<Integer> fishingRodPulls = new ArrayList<Integer>();
    public SimpleCollisionBox fireworksBox = null;
    public SimpleCollisionBox fishingRodPullBox = null;
    public LastInstance lastFlyingTicks;
    public LastInstance lastFlyingStatusChange;
    public LastInstance lastUnderwaterFlyingHack;
    public LastInstance lastStuckSpeedMultiplier;
    public LastInstance lastHardCollidingLerpingEntity;
    public LastInstance lastThirtyMillionHardBorder;
    public LastInstance lastTeleportTicks;
    public LastInstance lastPointThree;
    public LastInstance stuckOnEdge;
    public LastInstance lastStuckNorth;
    public LastInstance lastStuckSouth;
    public LastInstance lastStuckWest;
    public LastInstance lastStuckEast;
    public LastInstance lastVehicleSwitch;
    public double lastHorizontalOffset = 0.0;
    public double lastVerticalOffset = 0.0;

    public UncertaintyHandler(GrimPlayer player) {
        this.player = player;
        this.lastFlyingTicks = new LastInstance(player);
        this.lastFlyingStatusChange = new LastInstance(player);
        this.lastUnderwaterFlyingHack = new LastInstance(player);
        this.lastStuckSpeedMultiplier = new LastInstance(player);
        this.lastHardCollidingLerpingEntity = new LastInstance(player);
        this.lastThirtyMillionHardBorder = new LastInstance(player);
        this.lastTeleportTicks = new LastInstance(player);
        this.lastPointThree = new LastInstance(player);
        this.stuckOnEdge = new LastInstance(player);
        this.lastStuckNorth = new LastInstance(player);
        this.lastStuckSouth = new LastInstance(player);
        this.lastStuckWest = new LastInstance(player);
        this.lastStuckEast = new LastInstance(player);
        this.lastVehicleSwitch = new LastInstance(player);
        this.tick();
    }

    public void tick() {
        this.pistonX.add(0.0);
        this.pistonY.add(0.0);
        this.pistonZ.add(0.0);
        this.isStepMovement = false;
        this.isSteppingNearShulker = false;
        this.wasSteppingOnBouncyBlock = this.isSteppingOnBouncyBlock;
        this.isSteppingOnSlime = false;
        this.isSteppingOnBouncyBlock = false;
        this.isSteppingOnIce = false;
        this.isSteppingOnHoney = false;
        this.isSteppingNearBubbleColumn = false;
        this.isSteppingNearScaffolding = false;
        this.slimePistonBounces = new HashSet();
        this.tickFireworksBox();
    }

    public boolean wasAffectedByStuckSpeed() {
        return this.lastStuckSpeedMultiplier.hasOccurredSince(5);
    }

    public void tickFireworksBox() {
        this.fishingRodPullBox = this.fishingRodPulls.isEmpty() ? null : new SimpleCollisionBox();
        this.fireworksBox = null;
        for (int owner : this.fishingRodPulls) {
            PacketEntity entity = this.player.compensatedEntities.getEntity(owner);
            if (entity == null) continue;
            SimpleCollisionBox entityBox = entity.getPossibleCollisionBoxes();
            float scale = (float)entity.getAttributeValue(Attributes.SCALE);
            float width = BoundingBoxSize.getWidth(this.player, entity) * scale;
            float height = BoundingBoxSize.getHeight(this.player, entity) * scale;
            entityBox.maxY -= (double)height;
            entityBox.expand(-width / 2.0f, 0.0, -width / 2.0f);
            Vector maxLocation = new Vector(entityBox.maxX, entityBox.maxY, entityBox.maxZ);
            Vector minLocation = new Vector(entityBox.minX, entityBox.minY, entityBox.minZ);
            Vector diff = minLocation.subtract(new Vector(this.player.lastX, this.player.lastY + 1.4400000000000002, this.player.lastZ)).multiply(0.1);
            this.fishingRodPullBox.minX = Math.min(0.0, diff.getX());
            this.fishingRodPullBox.minY = Math.min(0.0, diff.getY());
            this.fishingRodPullBox.minZ = Math.min(0.0, diff.getZ());
            diff = maxLocation.subtract(new Vector(this.player.lastX, this.player.lastY + 1.4400000000000002, this.player.lastZ)).multiply(0.1);
            this.fishingRodPullBox.maxX = Math.max(0.0, diff.getX());
            this.fishingRodPullBox.maxY = Math.max(0.0, diff.getY());
            this.fishingRodPullBox.maxZ = Math.max(0.0, diff.getZ());
        }
        this.fishingRodPulls.clear();
        int maxFireworks = this.player.fireworks.getMaxFireworksAppliedPossible() * 2;
        if (maxFireworks <= 0 || !this.player.isGliding && !this.player.wasGliding) {
            return;
        }
        this.fireworksBox = new SimpleCollisionBox();
        Vector currentLook = ReachUtils.getLook(this.player, this.player.xRot, this.player.yRot);
        Vector lastLook = ReachUtils.getLook(this.player, this.player.lastXRot, this.player.lastYRot);
        double antiTickSkipping = this.player.isPointThree() ? 0.0 : 0.05;
        double minX = Math.min(-antiTickSkipping, currentLook.getX()) + Math.min(-antiTickSkipping, lastLook.getX());
        double minY = Math.min(-antiTickSkipping, currentLook.getY()) + Math.min(-antiTickSkipping, lastLook.getY());
        double minZ = Math.min(-antiTickSkipping, currentLook.getZ()) + Math.min(-antiTickSkipping, lastLook.getZ());
        double maxX = Math.max(antiTickSkipping, currentLook.getX()) + Math.max(antiTickSkipping, lastLook.getX());
        double maxY = Math.max(antiTickSkipping, currentLook.getY()) + Math.max(antiTickSkipping, lastLook.getY());
        double maxZ = Math.max(antiTickSkipping, currentLook.getZ()) + Math.max(antiTickSkipping, lastLook.getZ());
        minX *= 1.7;
        minY *= 1.7;
        minZ *= 1.7;
        maxX *= 1.7;
        maxY *= 1.7;
        maxZ *= 1.7;
        minX = Math.max(-1.7, minX);
        minY = Math.max(-1.7, minY);
        minZ = Math.max(-1.7, minZ);
        maxX = Math.min(1.7, maxX);
        maxY = Math.min(1.7, maxY);
        maxZ = Math.min(1.7, maxZ);
        this.fireworksBox = new SimpleCollisionBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public double getOffsetHorizontal(VectorData data) {
        double pointThree;
        double threshold = this.player.getMovementThreshold();
        boolean newVectorPointThree = this.player.couldSkipTick && data.isKnockback();
        boolean explicit003 = data.isZeroPointZeroThree() || this.lastMovementWasZeroPointZeroThree;
        boolean either003 = newVectorPointThree || explicit003;
        double d = pointThree = newVectorPointThree || this.lastMovementWasUnknown003VectorReset ? threshold : 0.0;
        if (explicit003) {
            pointThree = 0.546 * (threshold * 2.0) + threshold;
        }
        if (either003 && (this.influencedByBouncyBlock() || this.isSteppingOnHoney)) {
            pointThree = 0.7280000000000001 * (threshold * 2.0) + threshold;
        }
        if (either003 && this.isSteppingOnIce) {
            pointThree = 0.8999900000000001 * (threshold * 2.0) + threshold;
        }
        if (pointThree > threshold) {
            pointThree *= 0.8999900000000001;
        }
        if (either003 && (this.player.lastOnGround || this.player.isFlying)) {
            pointThree = 0.91 * (threshold * 2.0) + threshold;
        }
        if (either003 && (this.player.isGliding || this.player.wasGliding)) {
            pointThree = 0.99 * (threshold * 2.0) + threshold;
        }
        if (this.player.uncertaintyHandler.claimingLeftStuckSpeed) {
            pointThree = 0.15;
        }
        return pointThree;
    }

    public boolean influencedByBouncyBlock() {
        return this.isSteppingOnBouncyBlock || this.wasSteppingOnBouncyBlock;
    }

    public double getVerticalOffset(VectorData data) {
        if (this.player.uncertaintyHandler.claimingLeftStuckSpeed) {
            return 0.06;
        }
        if (this.player.uncertaintyHandler.wasSteppingOnBouncyBlock && (this.player.wasTouchingWater || this.player.wasTouchingLava)) {
            return 0.06;
        }
        if (this.lastFlyingTicks.hasOccurredSince(5) && Math.abs(data.vector.getY()) < 4.5 * (double)this.player.flySpeed - 0.25) {
            return 0.06;
        }
        double pointThree = this.player.getMovementThreshold();
        if (data.isTrident()) {
            return pointThree * 2.0;
        }
        if (this.player.couldSkipTick && (data.isKnockback() || this.player.isClimbing) && !data.isZeroPointZeroThree()) {
            return pointThree;
        }
        if (this.player.pointThreeEstimator.controlsVerticalMovement() && (data.isZeroPointZeroThree() || this.lastMovementWasZeroPointZeroThree)) {
            return pointThree * 2.0;
        }
        if (this.wasZeroPointThreeVertically || this.player.uncertaintyHandler.onGroundUncertain || this.player.uncertaintyHandler.lastPacketWasGroundPacket) {
            return pointThree;
        }
        return 0.0;
    }

    public double reduceOffset(double offset) {
        if (this.player.uncertaintyHandler.lastHardCollidingLerpingEntity.hasOccurredSince(3)) {
            offset -= 1.2;
        }
        if (this.player.uncertaintyHandler.isOrWasNearGlitchyBlock) {
            offset -= 0.25;
        }
        if (this.player.uncertaintyHandler.wasAffectedByStuckSpeed() && (!this.player.isPointThree() || this.player.inVehicle())) {
            offset -= 0.01;
        }
        if (this.player.uncertaintyHandler.influencedByBouncyBlock() && (!this.player.isPointThree() || this.player.inVehicle())) {
            offset -= 0.03;
        }
        if (this.player.compensatedEntities.self.getRiding() instanceof PacketEntityRideable) {
            PacketEntityRideable vehicle = (PacketEntityRideable)this.player.compensatedEntities.self.getRiding();
            if (vehicle.currentBoostTime < vehicle.boostTimeMax + 20) {
                offset -= 0.01;
            }
        }
        return Math.max(0.0, offset);
    }

    public void checkForHardCollision() {
        if (this.hasHardCollision()) {
            this.player.uncertaintyHandler.lastHardCollidingLerpingEntity.reset();
        }
    }

    private boolean hasHardCollision() {
        SimpleCollisionBox expandedBB = this.player.boundingBox.copy().expand(1.0);
        return this.isSteppingNearShulker || this.regularHardCollision(expandedBB) || this.striderCollision(expandedBB) || this.boatCollision(expandedBB);
    }

    private boolean regularHardCollision(SimpleCollisionBox expandedBB) {
        PacketEntity riding = this.player.compensatedEntities.self.getRiding();
        for (PacketEntity entity : this.player.compensatedEntities.entityMap.values()) {
            if (!entity.isBoat() && entity.getType() != EntityTypes.SHULKER || entity == riding || !entity.getPossibleCollisionBoxes().isIntersected(expandedBB)) continue;
            return true;
        }
        return false;
    }

    private boolean striderCollision(SimpleCollisionBox expandedBB) {
        if (this.player.compensatedEntities.self.getRiding() instanceof PacketEntityStrider) {
            for (PacketEntity entity : this.player.compensatedEntities.entityMap.values()) {
                if (entity.getType() != EntityTypes.STRIDER || entity == this.player.compensatedEntities.self.getRiding() || entity.hasPassenger(entity) || !entity.getPossibleCollisionBoxes().isIntersected(expandedBB)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean boatCollision(SimpleCollisionBox expandedBB) {
        PacketEntity riding = this.player.compensatedEntities.self.getRiding();
        if (riding == null || !riding.isBoat()) {
            return false;
        }
        for (PacketEntity entity : this.player.compensatedEntities.entityMap.values()) {
            if (entity == riding || !entity.isPushable() || riding.hasPassenger(entity) || !entity.getPossibleCollisionBoxes().isIntersected(expandedBB)) continue;
            return true;
        }
        return false;
    }
}

