/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.wolfvariant;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.wolfvariant.StaticWolfVariant;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntitySet;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTString;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.biome.Biome;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.biome.Biomes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.resources.ResourceLocation;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;

public interface WolfVariant
extends MappedEntity,
CopyableEntity<WolfVariant>,
DeepComparableEntity {
    public ResourceLocation getWildTexture();

    public ResourceLocation getTameTexture();

    public ResourceLocation getAngryTexture();

    public MappedEntitySet<Biome> getBiomes();

    public static WolfVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation wildTexture = new ResourceLocation(compound.getStringTagValueOrThrow("wild_texture"));
        ResourceLocation tameTexture = new ResourceLocation(compound.getStringTagValueOrThrow("tame_texture"));
        ResourceLocation angryTexture = new ResourceLocation(compound.getStringTagValueOrThrow("angry_texture"));
        MappedEntitySet<Biome> biomes = MappedEntitySet.decode(compound.getTagOrThrow("biomes"), version, Biomes.getRegistry());
        return new StaticWolfVariant(data, wildTexture, tameTexture, angryTexture, biomes);
    }

    public static NBT encode(WolfVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("wild_texture", new NBTString(variant.getWildTexture().toString()));
        compound.setTag("tame_texture", new NBTString(variant.getTameTexture().toString()));
        compound.setTag("angry_texture", new NBTString(variant.getAngryTexture().toString()));
        compound.setTag("biomes", MappedEntitySet.encode(variant.getBiomes(), version));
        return compound;
    }
}

