/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.instrument;

import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.instrument.Instruments;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.item.instrument.StaticInstrument;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.CopyableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.DeepComparableEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.mapper.MappedEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBT;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.nbt.NBTFloat;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.sound.Sound;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.MathUtil;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.adventure.AdventureSerializer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.mappings.TypesBuilderData;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.PacketWrapper;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import ac.grim.grimac.shaded.kyori.adventure.text.Component;

public interface Instrument
extends MappedEntity,
CopyableEntity<Instrument>,
DeepComparableEntity {
    public Sound getSound();

    public float getUseSeconds();

    default public int getUseDuration() {
        return MathUtil.floor(this.getUseSeconds() * 20.0f);
    }

    public float getRange();

    public Component getDescription();

    public static Instrument read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Instruments.getRegistry(), Instrument::readDirect);
    }

    public static Instrument readDirect(PacketWrapper<?> wrapper) {
        Sound sound = Sound.read(wrapper);
        float useSeconds = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readFloat() : (float)wrapper.readVarInt() * 20.0f;
        float range = wrapper.readFloat();
        Component description = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2) ? wrapper.readComponent() : Component.empty();
        return new StaticInstrument(sound, useSeconds, range, description);
    }

    public static void write(PacketWrapper<?> wrapper, Instrument instrument) {
        wrapper.writeMappedEntityOrDirect(instrument, Instrument::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Instrument instrument) {
        Sound.write(wrapper, instrument.getSound());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeFloat(instrument.getUseSeconds());
        } else {
            wrapper.writeVarInt(instrument.getUseDuration());
        }
        wrapper.writeFloat(instrument.getRange());
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            wrapper.writeComponent(instrument.getDescription());
        }
    }

    public static Instrument decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        Sound sound = Sound.decode(compound.getTagOrThrow("sound_event"), version);
        float useSeconds = compound.getNumberTagOrThrow("use_duration").getAsFloat();
        float range = compound.getNumberTagOrThrow("range").getAsFloat();
        Component description = AdventureSerializer.fromNbt(compound.getTagOrThrow("description"));
        return new StaticInstrument(data, sound, useSeconds, range, description);
    }

    public static NBT encode(Instrument instrument, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_event", Sound.encode(instrument.getSound(), version));
        compound.setTag("use_duration", new NBTFloat(instrument.getUseSeconds()));
        compound.setTag("range", new NBTFloat(instrument.getRange()));
        compound.setTag("description", AdventureSerializer.toNbt(instrument.getDescription()));
        return compound;
    }
}

